/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.schedule;

import com.irdstudio.bfp.executor.core.job.JavaDataJobDao;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.vo.SSrvsCronConf;
import com.irdstudio.bfp.executor.rest.engine.QuartzJobEngine;
import com.irdstudio.bfp.executor.rest.init.ExecutorInstInfo;
import com.irdstudio.bfp.executor.rest.schedule.QuartzManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ScheduleJobUtil {
    public static final String STATE_WAIT = "S";
    public static final String STATE_ARRANGED = "A";
    public static final String STATE_RUNNING = "R";
    public static final String STATE_FALSE = "F";
    private static Logger logger = Logger.getLogger(ScheduleJobUtil.class);
    public static String JOB_GROUP_NAME = "AGENT_JOB_GROUP";
    public static String TRIGGER_NAME = "AGENT_TRIGGER";
    public static String TRIGGER_GROUP_NAME = "AGENT_TRIGGER_GROUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJobsForExecutor() {
        logger.info((Object)"\u5f00\u59cb\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            ArrayList<Object> values = new ArrayList<Object>();
            String sql = "select * from s_srvs_cron_conf where agent_id = ?";
            values.add(ExecutorInstInfo.EXECUTOR_ID);
            List<SSrvsCronConf> cronConfList = dao.queryList(sql, values, SSrvsCronConf.class);
            for (SSrvsCronConf cronConf : cronConfList) {
                if (!ExecutorInstInfo.EXECUTOR_ID.equals(cronConf.getAgentId())) continue;
                if (cronConf.getJobState().equals(STATE_WAIT)) {
                    sql = "update s_srvs_cron_conf set job_state=? where job_code = ?";
                    values.clear();
                    values.add(STATE_ARRANGED);
                    values.add(cronConf.getJobCode());
                    dao.update(sql, values);
                }
                logger.info((Object)("\u52a0\u5165\u5b9a\u65f6\u4efb\u52a1\uff1a" + cronConf.getJobDesc() + "..."));
                QuartzManager.addJob(cronConf.getJobCode(), JOB_GROUP_NAME, TRIGGER_NAME + "-" + cronConf.getJobCode(), TRIGGER_GROUP_NAME, QuartzJobEngine.class, cronConf.getCronExpression());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        logger.info((Object)"\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }

    public static void stopJobsForAgent() {
        logger.info((Object)"\u5f00\u59cb\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        try {
            QuartzManager.shutdownJobs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info((Object)"\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }
}

