/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.server;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.bfp.executor.facade.InitBpmClient;
import com.irdstudio.bfp.executor.util.CommonUtil;
import com.irdstudio.bfp.executor.vo.BpmContext;
import com.irdstudio.bfp.executor.vo.BpmPlugin;
import com.irdstudio.bfp.executor.vo.BpmRequest;
import com.irdstudio.bfp.executor.vo.BpmResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmPluginEntrySevlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(BpmPluginEntrySevlet.class);

    public void init() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        log.info("\u8fdb\u5165get\u8bf7\u6c42---");
        httpServletResponse.setContentType("text/html;charset=UTF-8");
        BpmResponse bpmResponse = new BpmResponse();
        try {
            String inputStrLine;
            BufferedReader streamReader = new BufferedReader(new InputStreamReader((InputStream)httpServletRequest.getInputStream(), "UTF-8"));
            StringBuilder requestStrBuilder = new StringBuilder();
            while ((inputStrLine = streamReader.readLine()) != null) {
                requestStrBuilder.append(inputStrLine);
            }
            if (requestStrBuilder != null && requestStrBuilder.length() > 0) {
                log.info(requestStrBuilder.toString());
                Map requestMap = (Map)JSONObject.parseObject((String)requestStrBuilder.toString(), Map.class);
                BpmPlugin bpmPlugin = (BpmPlugin)JSONObject.parseObject((String)requestMap.get("plugin").toString(), BpmPlugin.class);
                String bpmPluginId = bpmPlugin.getId();
                log.info("\u6d41\u7a0b\u63d2\u4ef6\u6807\u8bc6[bpmPluginId\uff1a" + bpmPluginId + "]");
                if (InitBpmClient.getHandlerMap() != null && InitBpmClient.getHandlerMap().containsKey(bpmPluginId)) {
                    String className = (String)InitBpmClient.getHandlerMap().get(bpmPluginId);
                    log.info("\u5b9e\u73b0\u7c7b\u5168\u8def\u5f84[className\uff1a" + className + "]");
                    List paramList = (List)requestMap.get("param");
                    if (paramList != null && paramList.size() > 0) {
                        log.info("\u53c2\u6570[paramList: " + paramList.toString() + "]");
                        BpmRequest bpmRequest = new BpmRequest();
                        bpmRequest.setPlugin(bpmPlugin);
                        bpmRequest.setParam(paramList);
                        BpmContext bpmContext = (BpmContext)JSONObject.parseObject((String)requestMap.get("context").toString(), BpmContext.class);
                        log.info("\u8bf7\u6c42\u6570\u636ebpmContext\u5bf9\u8c61\uff1a" + JSONObject.toJSONString((Object)bpmContext));
                        bpmRequest.setContext(bpmContext);
                        log.info("\u8bf7\u6c42\u6570\u636ebpmRequest\u5bf9\u8c61\uff1a" + JSONObject.toJSONString((Object)bpmRequest));
                        bpmResponse = (BpmResponse)CommonUtil.reflectInvoke(className, "execute", bpmRequest);
                    } else {
                        bpmResponse.setRspCode("7");
                        bpmResponse.setRspMsg("\u5177\u4f53\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                } else {
                    bpmResponse.setRspCode("7");
                    bpmResponse.setRspMsg("\u63d2\u4ef6\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728");
                }
            } else {
                bpmResponse.setRspCode("7");
                bpmResponse.setRspMsg("\u8bf7\u6c42\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            log.info("\u8fd4\u56de\u6570\u636eparseObject\u5bf9\u8c61\uff1a" + JSONObject.toJSONString((Object)bpmResponse));
            PrintWriter out = httpServletResponse.getWriter();
            String resJSON = JSONObject.toJSONString((Object)bpmResponse);
            out.print(resJSON);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        log.info("\u8fdb\u5165post\u8bf7\u6c42---");
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

