/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.client;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.bfp.executor.facade.InitBpmClient;
import com.irdstudio.bfp.executor.service.BpaService;
import com.irdstudio.bfp.executor.util.CommonUtil;
import com.irdstudio.bfp.executor.util.HttpClient;
import com.irdstudio.bfp.executor.vo.ResponseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpaHttpClient
implements BpaService {
    private static final Logger log = LoggerFactory.getLogger(BpaHttpClient.class);

    @Override
    public ResponseVO startBatch(String bpaSerialNo, String bpmCode, String bpmVersion, String batchAction) {
        log.info("\u5f00\u59cb\u8c03\u7528\u6d41\u7a0bbpaSerialNo:{}, bpmCode:{}, bpmVersion:{}, batchAction:{}", new Object[]{bpaSerialNo, bpmCode, bpmVersion, batchAction});
        ResponseVO responseVO = this.check(bpaSerialNo, bpmCode, bpmVersion, batchAction);
        if (!"success".equals(responseVO.getFlag())) {
            return responseVO;
        }
        StringBuilder url = new StringBuilder("/bpm-agent/agent/bpa/start");
        String json = HttpClient.get(this.getUrlParam(url, bpaSerialNo, bpmCode, bpmVersion, batchAction), InitBpmClient.getTimeOut());
        log.info("\u6d41\u7a0b\u8fd4\u56dejson\u6570\u636e:{}", (Object)json);
        if (CommonUtil.isBlank(json)) {
            responseVO.setFlag("fail");
            responseVO.setMsg("\u4e1a\u52a1\u6d41\u8f6c\u6267\u884c\u8c03\u7528\u5931\u8d25......");
            return responseVO;
        }
        return (ResponseVO)JSONObject.parseObject((String)json, ResponseVO.class);
    }

    @Override
    public ResponseVO startBatchManual(String bpaSerialNo, String bpmCode, String bpmVersion, String batchAction) {
        log.info("\u5f00\u59cb\u8c03\u7528\u6d41\u7a0bbpaSerialNo:{}, bpmCode:{}, bpmVersion:{}, batchAction:{}", new Object[]{bpmCode, bpmVersion, bpaSerialNo, batchAction});
        ResponseVO responseVO = this.check(bpaSerialNo, bpmCode, bpmVersion, batchAction);
        if (!"success".equals(responseVO.getFlag())) {
            return responseVO;
        }
        StringBuilder url = new StringBuilder("/bpm-agent/agent/bpw/start");
        String json = HttpClient.get(this.getUrlParam(url, bpaSerialNo, bpmCode, bpmVersion, batchAction), InitBpmClient.getTimeOut());
        log.info("\u6d41\u7a0b\u8fd4\u56dejson\u6570\u636e:{}", (Object)json);
        if (CommonUtil.isBlank(json)) {
            responseVO.setFlag("fail");
            responseVO.setMsg("\u4e1a\u52a1\u6d41\u8f6c\u6267\u884c\u8c03\u7528\u5931\u8d25......");
            return responseVO;
        }
        return (ResponseVO)JSONObject.parseObject((String)json, ResponseVO.class);
    }

    private String getUrlParam(StringBuilder url, String bpaSerialNo, String bpmCode, String bpmVersion, String batchAction) {
        url.append("?bpaSerialNo=");
        url.append(bpaSerialNo);
        url.append("&bpmCode=");
        url.append(bpmCode);
        url.append("&bpmVersion=");
        url.append(bpmVersion);
        url.append("&batchAction=");
        url.append(batchAction);
        return url.toString();
    }
}

