/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.util;

import com.irdstudio.bfp.executor.facade.InitBpmClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);

    public static String get(String url, Integer timeOut) {
        return HttpClient.request(InitBpmClient.getAddress() + url, null, "GET", timeOut, new HashMap<String, String>());
    }

    public static String get(String url, Map<String, String> params, Integer timeOut) {
        StringBuilder urlParams = new StringBuilder(InitBpmClient.getAddress());
        urlParams.append(url);
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (i == 0) {
                urlParams.append("?");
            } else {
                urlParams.append("&");
            }
            urlParams.append(entry.getKey());
            urlParams.append("=");
            urlParams.append(entry.getValue());
            ++i;
        }
        return HttpClient.request(urlParams.toString(), null, "GET", timeOut, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String url, String params, String method, Integer timeOut, Map<String, String> headers) {
        log.info("\u8c03\u7528\u5730\u5740: {}", (Object)url);
        URL postUrl = null;
        HttpURLConnection connection = null;
        try {
            postUrl = new URL(url);
            connection = (HttpURLConnection)postUrl.openConnection();
            connection.setConnectTimeout(timeOut);
            connection.setReadTimeout(timeOut);
            connection.setDoOutput(true);
            connection.setAllowUserInteraction(false);
            connection.setRequestMethod(method);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            switch (method) {
                case "GET": {
                    break;
                }
                case "POST": {
                    OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                    out.write(params.toCharArray());
                    out.flush();
                    out.close();
                    break;
                }
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection.disconnect();
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("wd", "JAVA");
        System.out.println(HttpClient.get("https://www.baidu.com/s", param, 6000));
    }
}

