/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.api.rest;

import com.irdstudio.bsp.console.service.facade.BatBatchInfoConfigService;
import com.irdstudio.bsp.console.service.facade.BatBatchStageConfigService;
import com.irdstudio.bsp.console.service.facade.SAgentInfoService;
import com.irdstudio.bsp.console.service.facade.SSrvsCronConfService;
import com.irdstudio.bsp.console.service.vo.BatBatchInfoConfigVO;
import com.irdstudio.bsp.console.service.vo.BatBatchStageConfigVO;
import com.irdstudio.bsp.console.service.vo.SAgentInfoVO;
import com.irdstudio.bsp.console.service.vo.SSrvsCronConfVO;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.util.AgentApiUtil;
import com.irdstudio.sdk.ssm.util.StringUtil;
import com.irdstudio.sdk.ssm.vo.ResponseVO;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BatBatchInfoConfigController
extends AbstractController {
    @Autowired
    @Qualifier(value="batchConfigService")
    private BatBatchInfoConfigService batBatchInfoConfigService;
    @Autowired
    @Qualifier(value="sSrvsCronConfService")
    private SSrvsCronConfService sSrvsCronConfService;
    @Autowired
    @Qualifier(value="sAgentInfoService")
    private SAgentInfoService sAgentInfoService;
    @Autowired
    @Qualifier(value="stageConfigService")
    private BatBatchStageConfigService batBatchStageConfigService;

    @RequestMapping(value={"/bat/batch/info/configs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BatBatchInfoConfigVO>> queryBatBatchInfoConfigAll(BatBatchInfoConfigVO vo) {
        List<BatBatchInfoConfigVO> outputVo = this.batBatchInfoConfigService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BatBatchInfoConfigVO> queryByPk(@PathVariable(value="batchId") String batchId) {
        BatBatchInfoConfigVO inVo = new BatBatchInfoConfigVO();
        inVo.setBatchId(batchId);
        BatBatchInfoConfigVO outputVo = this.batBatchInfoConfigService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BatBatchInfoConfigVO inBatBatchInfoConfigVo) {
        int outputVo = this.batBatchInfoConfigService.deleteByPk(inBatBatchInfoConfigVo);
        if (outputVo == 1) {
            SSrvsCronConfVO paramVO = new SSrvsCronConfVO();
            paramVO.setJobCode(inBatBatchInfoConfigVo.getBatchId());
            this.sSrvsCronConfService.deleteByPk(paramVO);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BatBatchInfoConfigVO inBatBatchInfoConfigVo) throws Exception {
        int outputVo = this.batBatchInfoConfigService.updateByPk(inBatBatchInfoConfigVo);
        if (outputVo == 1) {
            SSrvsCronConfVO paramVO = new SSrvsCronConfVO();
            paramVO.setJobCode(inBatBatchInfoConfigVo.getBatchId());
            SSrvsCronConfVO confVO = this.sSrvsCronConfService.queryByPk(paramVO);
            int count = 1;
            if (confVO != null && (count = this.sSrvsCronConfService.deleteByPk(paramVO)) != 1) {
                ResponseData data = this.getResponseData(count);
                data.setMessage("\u5220\u9664\u5b9a\u65f6\u8c03\u5ea6\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff01\u64cd\u4f5c\u5f71\u54cd\u4e86" + count + "\u6761\u8bb0\u5f55");
                return data;
            }
            if (count == 1 && inBatBatchInfoConfigVo.getLaunchType() != null && "1".equals(inBatBatchInfoConfigVo.getLaunchType())) {
                SSrvsCronConfVO addConfVO = new SSrvsCronConfVO();
                addConfVO.setJobCode(inBatBatchInfoConfigVo.getBatchId());
                addConfVO.setJobDesc(inBatBatchInfoConfigVo.getBatchName());
                addConfVO.setCronExpression(inBatBatchInfoConfigVo.getBatchCronValue());
                addConfVO.setAgentId(inBatBatchInfoConfigVo.getAgentId());
                addConfVO.setSubsCode(inBatBatchInfoConfigVo.getSubsCode());
                addConfVO.setJobState("S");
                addConfVO.setJobClass("com.irdstudio.bsp.executor.rest.job.BatchStarter");
                addConfVO.setJobClassType("local");
                addConfVO.setJobMethod("doExcetue");
                addConfVO.setAgainTime(3);
                addConfVO.setRetrySecond(60);
                if (confVO != null) {
                    addConfVO.setJobClassType(confVO.getJobClassType());
                    addConfVO.setJobClass(confVO.getJobClass());
                    addConfVO.setJobMethod(confVO.getJobMethod());
                    addConfVO.setJobDesc(confVO.getJobDesc());
                }
                this.sSrvsCronConfService.insertSSrvsCronConf(addConfVO);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBatBatchInfoConfig(@RequestBody BatBatchInfoConfigVO inBatBatchInfoConfigVo) {
        int outputVo = this.batBatchInfoConfigService.insertBatBatchInfoConfig(inBatBatchInfoConfigVo);
        if (outputVo == 1) {
            BatBatchStageConfigVO batBatchStageConfigVO = new BatBatchStageConfigVO();
            batBatchStageConfigVO.setBatchId(inBatBatchInfoConfigVo.getBatchId());
            batBatchStageConfigVO.setStageId("01");
            batBatchStageConfigVO.setStageName("\u6279\u6b21\u5f00\u59cb");
            batBatchStageConfigVO.setRemark("\u6279\u6b21\u5f00\u59cb");
            this.batBatchStageConfigService.insertBatBatchStageConfig(batBatchStageConfigVO);
            batBatchStageConfigVO.setStageId("02");
            batBatchStageConfigVO.setStageName("\u6570\u636e\u88c5\u8f7d");
            batBatchStageConfigVO.setRemark("\u6570\u636e\u88c5\u8f7d");
            this.batBatchStageConfigService.insertBatBatchStageConfig(batBatchStageConfigVO);
            batBatchStageConfigVO.setStageId("03");
            batBatchStageConfigVO.setStageName("\u6570\u636e\u5378\u8f7d");
            batBatchStageConfigVO.setRemark("\u6570\u636e\u5378\u8f7d");
            this.batBatchStageConfigService.insertBatBatchStageConfig(batBatchStageConfigVO);
            batBatchStageConfigVO.setStageId("04");
            batBatchStageConfigVO.setStageName("\u4e1a\u52a1\u5904\u7406");
            batBatchStageConfigVO.setRemark("\u4e1a\u52a1\u5904\u7406");
            this.batBatchStageConfigService.insertBatBatchStageConfig(batBatchStageConfigVO);
            batBatchStageConfigVO.setStageId("05");
            batBatchStageConfigVO.setStageName("\u6279\u6b21\u7ed3\u675f");
            batBatchStageConfigVO.setRemark("\u6279\u6b21\u7ed3\u675f");
            this.batBatchStageConfigService.insertBatBatchStageConfig(batBatchStageConfigVO);
            if (inBatBatchInfoConfigVo.getLaunchType() != null && "1".equals(inBatBatchInfoConfigVo.getLaunchType())) {
                SSrvsCronConfVO addConfVO = new SSrvsCronConfVO();
                addConfVO.setJobCode(inBatBatchInfoConfigVo.getBatchId());
                addConfVO.setJobDesc(inBatBatchInfoConfigVo.getBatchName());
                addConfVO.setCronExpression(inBatBatchInfoConfigVo.getBatchCronValue());
                addConfVO.setAgentId(inBatBatchInfoConfigVo.getAgentId());
                addConfVO.setSubsCode(inBatBatchInfoConfigVo.getSubsCode());
                addConfVO.setJobState("S");
                addConfVO.setJobClass("com.irdstudio.bsp.executor.rest.job.BatchStarter");
                addConfVO.setJobClassType("local");
                addConfVO.setJobMethod("doExcetue");
                addConfVO.setAgainTime(3);
                addConfVO.setRetrySecond(60);
                this.sSrvsCronConfService.insertSSrvsCronConf(addConfVO);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/action/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> startBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction) {
        ResponseData data;
        block9: {
            BatBatchInfoConfigVO params = new BatBatchInfoConfigVO();
            params.setBatchId(batchId);
            BatBatchInfoConfigVO batchConf = this.batBatchInfoConfigService.queryByPk(params);
            SAgentInfoVO inVo = new SAgentInfoVO();
            inVo.setAgentId(batchConf.getAgentId());
            SAgentInfoVO agentInfo = this.sAgentInfoService.queryByPk(inVo);
            data = null;
            if (agentInfo != null && StringUtil.isNotEmpty((String)agentInfo.getAgentUrl())) {
                try {
                    ResponseVO response;
                    if ("none".equals(batchSerialNo)) {
                        batchSerialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
                    }
                    if ((response = AgentApiUtil.actionBatch((String)agentInfo.getAgentUrl(), (String)batchSerialNo, (String)batchId, (String)batchAction)) != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                        data = this.getResponseData(true);
                        if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                            data.setMessage(response.getMsg());
                            logger.info(response.getMsg());
                        } else {
                            data.setMessage("\u6279\u6b21\u6267\u884c\u6210\u529f\uff01");
                            logger.info("\u6279\u6b21\u6267\u884c\u6210\u529f\uff01agentId:" + agentInfo.getAgentId() + ", agent\u5730\u5740\uff1a" + agentInfo.getAgentUrl() + ", \u6279\u6b21\u53f7\uff1a" + batchId + ", \u6279\u6b21\u52a8\u4f5c\uff1a" + batchAction + "\uff0c\u6279\u6b21\u6d41\u6c34\u53f7\uff1a" + batchSerialNo);
                        }
                        break block9;
                    }
                    data = this.getResponseData(false);
                    if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                        data.setMessage(response.getMsg());
                        logger.info(response.getMsg());
                        break block9;
                    }
                    data.setMessage("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl(), (Throwable)e);
                    data = this.getResponseData(false);
                    data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl());
                }
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f");
                data = this.getResponseData(false);
                data.setMessage("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
            }
        }
        return data;
    }

    @RequestMapping(value={"/bat/bpm/batch/info/action/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> startBpmBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction) {
        String agentUrl = PropertiesUtil.getPropertyByKey((String)"application", (String)"bpm.agent.url");
        ResponseData data = null;
        try {
            ResponseVO response = AgentApiUtil.actionBpmBatch((String)agentUrl, (String)batchId, (String)batchSerialNo, (String)batchAction);
            if (response != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                data = this.getResponseData(true);
                if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                    data.setMessage(response.getMsg());
                    logger.info(response.getMsg());
                } else {
                    data.setMessage("\u4e1a\u52a1\u6d41\u8f6c\u6279\u6b21\u6267\u884c\u6210\u529f\uff01");
                    logger.info(batchSerialNo + "\u6279\u6b21\u6267\u884c\u6210\u529f\uff01agent\u5730\u5740\uff1a" + agentUrl + ", \u6279\u6b21\u53f7\uff1a" + batchId + ", \u6279\u6b21\u6d41\u6c34\u53f7\uff1a" + batchSerialNo + ", \u6279\u6b21\u52a8\u4f5c\uff1a" + batchAction);
                }
            } else {
                data = this.getResponseData(false);
                if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                    data.setMessage(response.getMsg());
                    logger.info(response.getMsg());
                } else {
                    data.setMessage("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
            data = this.getResponseData(false);
            data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
        }
        return data;
    }
}

