/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.service.impl;

import com.irdstudio.bsp.console.dao.BatInstTaskDao;
import com.irdstudio.bsp.console.dao.BpmBatInstTaskDao;
import com.irdstudio.bsp.console.dao.domain.BatInstTask;
import com.irdstudio.bsp.console.service.facade.BatInstTaskService;
import com.irdstudio.bsp.console.service.vo.BatInstTaskTree;
import com.irdstudio.bsp.console.service.vo.BatInstTaskVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instTaskService")
public class BatInstTaskServiceImpl
implements BatInstTaskService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(BatInstTaskServiceImpl.class);
    @Autowired
    private BatInstTaskDao batInstTaskDao;
    @Autowired
    private BpmBatInstTaskDao bpmBatInstTaskDao;

    @Override
    public int insertBatInstTask(BatInstTaskVO inBatInstTaskVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBatInstTaskVo.toString());
        int num = 0;
        try {
            BatInstTask batInstTask = new BatInstTask();
            this.beanCopy((Object)inBatInstTaskVo, (Object)batInstTask);
            num = this.batInstTaskDao.insertBatInstTask(batInstTask);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(BatInstTaskVO inBatInstTaskVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBatInstTaskVo));
        int num = 0;
        try {
            BatInstTask batInstTask = new BatInstTask();
            this.beanCopy((Object)inBatInstTaskVo, (Object)batInstTask);
            num = this.batInstTaskDao.deleteByPk(batInstTask);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBatInstTaskVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(BatInstTaskVO inBatInstTaskVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBatInstTaskVo.toString());
        int num = 0;
        try {
            BatInstTask batInstTask = new BatInstTask();
            this.beanCopy((Object)inBatInstTaskVo, (Object)batInstTask);
            num = this.batInstTaskDao.updateByPk(batInstTask);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBatInstTaskVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public BatInstTaskVO queryByPk(BatInstTaskVO inBatInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inBatInstTaskVo));
        try {
            BatInstTask queryBatInstTask = new BatInstTask();
            this.beanCopy((Object)inBatInstTaskVo, (Object)queryBatInstTask);
            BatInstTask queryRslBatInstTask = this.batInstTaskDao.queryByPk(queryBatInstTask);
            if (Objects.nonNull((Object)queryRslBatInstTask)) {
                BatInstTaskVO outBatInstTaskVo = (BatInstTaskVO)((Object)this.beanCopy((Object)queryRslBatInstTask, (Object)new BatInstTaskVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outBatInstTaskVo.toString());
                return outBatInstTaskVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BatInstTaskVO> queryAllOwner(BatInstTaskVO batInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BatInstTask> batInstTasks = this.batInstTaskDao.queryAllOwnerByPage(batInstTaskVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + batInstTasks.size());
            this.pageSet(batInstTasks, batInstTaskVo);
            list = (List)this.beansCopy(batInstTasks, BatInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BatInstTaskVO> queryAllCurrOrg(BatInstTaskVO batInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BatInstTask> batInstTasks = this.batInstTaskDao.queryAllCurrOrgByPage(batInstTaskVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + batInstTasks.size());
        List list = null;
        try {
            this.pageSet(batInstTasks, batInstTaskVo);
            list = (List)this.beansCopy(batInstTasks, BatInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BatInstTaskVO> queryAllCurrDownOrg(BatInstTaskVO batInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BatInstTask> batInstTasks = this.batInstTaskDao.queryAllCurrDownOrgByPage(batInstTaskVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + batInstTasks.size());
        List list = null;
        try {
            this.pageSet(batInstTasks, batInstTaskVo);
            list = (List)this.beansCopy(batInstTasks, BatInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BatInstTaskTree> queryBatInstTaskTree(BatInstTaskVO batInstTaskVo) {
        ArrayList<BatInstTaskTree> taskTree = new ArrayList<BatInstTaskTree>();
        String text = batInstTaskVo.getBatchId() + "(" + batInstTaskVo.getBatchSerialNo() + ")";
        BatInstTaskTree root = new BatInstTaskTree(batInstTaskVo.getBatchSerialNo(), text);
        taskTree.add(root);
        HashMap stageMap = new HashMap();
        List<BatInstTask> batInstTasks = this.batInstTaskDao.queryAllInstTask(batInstTaskVo);
        for (int i = 0; i < batInstTasks.size(); ++i) {
            BatInstTaskTree stageNode;
            BatInstTask task = batInstTasks.get(i);
            BatInstTaskTree<BatInstTask> taskNode = new BatInstTaskTree<BatInstTask>(task.getTaskId(), task.getTaskName());
            taskNode.setAttributes(task);
            taskNode.setIconCls("task-tree-icon");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new BatInstTaskTree(task.getStageId(), task.getStageName());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (BatInstTaskTree)((Object)stageMap.get(task.getStageId()));
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @Override
    public int updateTaskInterveneState(BatInstTaskVO batInstTaskVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u4eba\u5de5\u5e72\u9884\u72b6\u6001\u6570\u636e\u4e3a:" + batInstTaskVo.toString());
        int num = 0;
        try {
            BatInstTask batInstTask = new BatInstTask();
            this.beanCopy((Object)batInstTaskVo, (Object)batInstTask);
            num = this.batInstTaskDao.updateTaskInterveneState(batInstTask);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u4eba\u5de5\u5e72\u9884\u72b6\u6001\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)batInstTaskVo) + "\u4fee\u6539\u7684\u4eba\u5de5\u5e72\u9884\u72b6\u6001\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public List<BatInstTaskTree> queryBpmBatInstTaskTree(BatInstTaskVO batInstTaskVo) {
        ArrayList<BatInstTaskTree> taskTree = new ArrayList<BatInstTaskTree>();
        String text = batInstTaskVo.getBatchId() + "(" + batInstTaskVo.getBatchSerialNo() + ")";
        BatInstTaskTree root = new BatInstTaskTree(batInstTaskVo.getBatchSerialNo(), text);
        taskTree.add(root);
        HashMap stageMap = new HashMap();
        List<BatInstTask> batInstTasks = this.bpmBatInstTaskDao.queryBpmAllInstTask(batInstTaskVo);
        for (int i = 0; i < batInstTasks.size(); ++i) {
            BatInstTaskTree stageNode;
            BatInstTask task = batInstTasks.get(i);
            BatInstTaskTree<BatInstTask> taskNode = new BatInstTaskTree<BatInstTask>(task.getTaskId(), task.getTaskName());
            taskNode.setAttributes(task);
            taskNode.setIconCls("task-tree-icon");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new BatInstTaskTree(task.getStageId(), task.getStageName());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (BatInstTaskTree)((Object)stageMap.get(task.getStageId()));
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @Override
    public List<BatInstTaskTree> queryBpmBatInstTaskHisTree(BatInstTaskVO batInstTaskVo) {
        ArrayList<BatInstTaskTree> taskTree = new ArrayList<BatInstTaskTree>();
        String text = batInstTaskVo.getBatchId() + "(" + batInstTaskVo.getBatchSerialNo() + ")";
        BatInstTaskTree root = new BatInstTaskTree(batInstTaskVo.getBatchSerialNo(), text);
        taskTree.add(root);
        HashMap stageMap = new HashMap();
        List<BatInstTask> batInstTasks = this.bpmBatInstTaskDao.queryBpmAllInstTaskHis(batInstTaskVo);
        for (int i = 0; i < batInstTasks.size(); ++i) {
            BatInstTaskTree stageNode;
            BatInstTask task = batInstTasks.get(i);
            BatInstTaskTree<BatInstTask> taskNode = new BatInstTaskTree<BatInstTask>(task.getTaskId(), task.getTaskName());
            taskNode.setAttributes(task);
            taskNode.setIconCls("task-tree-icon");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new BatInstTaskTree(task.getStageId(), task.getStageName());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (BatInstTaskTree)((Object)stageMap.get(task.getStageId()));
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @Override
    public List<BatInstTaskVO> queryBpmAllOwner(BatInstTaskVO batInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BatInstTask> batInstTasks = this.bpmBatInstTaskDao.queryBpmAllOwnerByPage(batInstTaskVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + batInstTasks.size());
            this.pageSet(batInstTasks, batInstTaskVo);
            list = (List)this.beansCopy(batInstTasks, BatInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BatInstTaskVO> queryBpmHisAllOwner(BatInstTaskVO batInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BatInstTask> batInstTasks = this.bpmBatInstTaskDao.queryBpmHisAllOwnerByPage(batInstTaskVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + batInstTasks.size());
            this.pageSet(batInstTasks, batInstTaskVo);
            list = (List)this.beansCopy(batInstTasks, BatInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

