/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.batch;

import com.irdstudio.bsp.executor.core.batch.BatchDataUtil;
import com.irdstudio.bsp.executor.core.batch.BatchRunProcess;
import com.irdstudio.bsp.executor.core.batch.dao.BatBatchInfoConfig;
import com.irdstudio.bsp.executor.core.batch.dao.BatInstBatch;
import com.irdstudio.bsp.executor.core.batch.dao.BatInstTask;
import com.irdstudio.bsp.executor.core.batch.dao.BatInstTaskDao;
import com.irdstudio.bsp.executor.core.batch.dao.BatTaskUnitConfig;
import com.irdstudio.bsp.executor.core.batch.dao.BatTaskUnitConfigDao;
import com.irdstudio.bsp.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.bsp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bsp.executor.core.tinycore.jdbc.util.DataMoveUtil;
import com.irdstudio.bsp.executor.core.tinycore.jdbc.util.TableMove;
import com.irdstudio.bsp.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.bsp.executor.core.util.date.DateCalculate;
import com.irdstudio.bsp.executor.core.util.date.DateConvert;
import com.irdstudio.bsp.executor.core.util.pub.ConnectionUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BatchRunEngine {
    private static final String BATCH_RUN = "run";
    private static final String BATCH_STOP = "stop";
    private static final String BATCH_RERUN = "rerun";
    private static final String BATCH_CONTINUE = "continue";
    private String batchAction;
    private String batchId;

    public BatchRunEngine(String batchAction, String batchId) {
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
    }

    public void start() throws Exception {
        if (BATCH_RUN.equals(this.batchAction)) {
            this.doRunBatch();
        } else if (BATCH_STOP.equals(this.batchAction)) {
            this.doStopBatch();
        } else if (BATCH_RERUN.equals(this.batchAction)) {
            this.doRerunBatch();
        } else if (BATCH_CONTINUE.equals(this.batchAction)) {
            this.doContinueBatch();
        }
    }

    private void doRunBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd");
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u3010" + this.batchId + "\u3011\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String subsCode = batchConfig.getSubsCode();
            SSubsInfo sSubsInfo = BatchDataUtil.getSSubsInfo(conn, subsCode);
            if (StringUtils.isBlank((CharSequence)subsCode)) {
                throw new Exception("\u83b7\u53d6\u6279\u6b21\u6240\u5c5e\u7cfb\u7edf\u4ee3\u7801\u4e3a\u7a7a\uff01");
            }
            if (sSubsInfo == null) {
                throw new Exception("\u6839\u636e\u5b50\u7cfb\u7edf\u4ee3\u7801\u3010" + subsCode + "\u3011\u67e5\u8be2\u5b50\u7cfb\u7edf\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BatInstBatch batchInst = BatchDataUtil.getBatInstBatch(conn, this.batchId);
            if (batchInst != null) {
                if (!"9".equals(batchInst.getBatchState())) {
                    throw new Exception("\u6279\u6b21\u5c1a\u672a\u5b8c\u6210\uff01");
                }
                String subsBatDate = sSubsInfo.getSubsBatDate();
                if (StringUtils.isBlank((CharSequence)subsBatDate)) {
                    throw new Exception("\u83b7\u53d6\u5b50\u7cfb\u7edf\u6279\u6b21\u5b8c\u6210\u65e5\u671f\u4e3a\u7a7a\uff01");
                }
                String batchDate = batchInst.getBatchDate();
                if (StringUtils.isBlank((CharSequence)batchDate)) {
                    throw new Exception("\u83b7\u53d6\u6279\u6b21\u5b9e\u4f8b\u8868\u4e2d\u7684\u6279\u6b21\u65e5\u671f\u4e3a\u7a7a\uff01");
                }
                if (format.parse(subsBatDate).before(format.parse(batchDate)) && !"M".equals(batchConfig.getIsRunAgain())) {
                    throw new Exception("\u4e0a\u4e00\u65e5\u671f\u3010" + subsBatDate + "\u3011\u7684\u6279\u6b21\u5c1a\u672a\u8fd0\u884c\u6210\u529f\uff01");
                }
                if (format.parse(subsBatDate).after(format.parse(batchDate))) {
                    throw new Exception("\u4e0a\u6b21\u6279\u6b21\u5b8c\u6210\u65e5\u671f\u3010" + subsBatDate + "\u3011\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            String cond = " where batch_id = '" + this.batchId + "'";
            this.dataMove(conn, "bat_inst_batch", "bat_inst_batch_h", cond);
            this.dataMove(conn, "bat_inst_task", "bat_inst_task_h", cond);
            this.dataMove(conn, "plugin_exec_log", "plugin_exec_log_h", " where batch_sn like '" + this.batchId + "%'");
            String condition1 = " where batch_id = '" + this.batchId + "'";
            TableMove batchDataMoveInst = DataMoveUtil.createTableMoveInst(conn, "bat_batch_info_config", "bat_inst_batch");
            String batchDate = DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(sSubsInfo.getSubsBatDate()), 1));
            String preString = this.batchId + batchDate.replace("-", "");
            String no = "1";
            String batchSerialNo = preString + no;
            if (batchInst != null) {
                String bab = batchInst.getBatchSerialNo().substring(0, preString.length());
                no = batchInst.getBatchSerialNo().substring(preString.length(), batchInst.getBatchSerialNo().length());
                if ("M".equals(batchConfig.getIsRunAgain()) && bab.equals(preString)) {
                    batchSerialNo = preString + (Integer.valueOf(no) + 1);
                }
            }
            batchDataMoveInst.addValueMapping("batch_serial_no", batchSerialNo);
            batchDataMoveInst.addValueMapping("batch_order", no);
            batchDataMoveInst.addValueMapping("batch_date", batchDate);
            batchDataMoveInst.addValueMapping("start_time", CurrentDateUtil.getTodayDateEx2());
            batchDataMoveInst.addValueMapping("batch_state", String.valueOf(8));
            batchDataMoveInst.addValueMapping("batch_intervene_state", String.valueOf(0));
            batchDataMoveInst.setCondition(condition1);
            batchDataMoveInst.executeCopy();
            String sql1 = "insert into bat_inst_task(batch_id,batch_order,batch_date,task_id,task_name,stage_id,stage_name,task_run_state,task_intervene_state,batch_serial_no)";
            String sql2 = "select a.batch_id,'" + no + "' as batch_order,'" + batchDate + "' as batch_date,a.task_id,a.task_name,a.stage_id,b.stage_name,\t'" + 0 + "' as task_run_state,'" + 0 + "' as task_intervene_state, '" + batchSerialNo + "' as batch_serial_no  from bat_task_unit_config a,bat_batch_stage_config b where a.batch_id='" + this.batchId + "' and a.task_use_state='0' and (a.task_use_area = '1' or a.task_use_area = '2') and a.batch_id = b.batch_id  and a.stage_id = b.stage_id ";
            boolean moveFlag = DataMoveUtil.executeCustomCopy(conn, sql1, sql2);
            if (moveFlag) {
                BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
                batRunProcess.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doStopBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BatBatchInfoConfig batBatchInfoConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batBatchInfoConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BatInstTaskDao batInstTaskDao = new BatInstTaskDao(conn);
            String szCondition = "where batch_id = '" + this.batchId + "' and task_run_state = '2'";
            List<BatInstTask> batInstTaskList = batInstTaskDao.queryWithCond(szCondition, "");
            if (batInstTaskList.size() == 0) {
                throw new Exception("\u5f53\u524d\u6279\u6b21\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff01");
            }
            Iterator<BatInstTask> it = batInstTaskList.iterator();
            while (it.hasNext()) {
                String taskId = it.next().getTaskId();
                BatTaskUnitConfigDao batTaskUnitConfigDao = new BatTaskUnitConfigDao(conn);
                String condition = " where previous_task_id = '" + taskId + "'";
                List<BatTaskUnitConfig> batTaskUnitConfigList = batTaskUnitConfigDao.queryWithCond(condition, "");
                if (batTaskUnitConfigList.size() == 0) continue;
                Iterator<BatTaskUnitConfig> batTaskUnitConfigIt = batTaskUnitConfigList.iterator();
                while (batTaskUnitConfigIt.hasNext()) {
                    String nextTaskId = batTaskUnitConfigIt.next().getTaskId();
                    String condi = " set task_run_state = '7' where batch_id = '" + this.batchId + "' and task_id = '" + nextTaskId + "'";
                    batInstTaskDao.updateBatInstTask(condi);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doRerunBatch() throws Exception {
        Connection conn = null;
        try {
            conn = ConnectionUtil.getConnection();
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String isRunAgain = batchConfig.getIsRunAgain();
            if (StringUtils.isBlank((CharSequence)isRunAgain)) {
                throw new Exception("\u67e5\u8be2\u662f\u5426\u5141\u8bb8\u91cd\u8dd1\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if ("N".equals(isRunAgain)) {
                throw new Exception("\u8be5\u6279\u6b21\u4e0d\u652f\u6301\u91cd\u8dd1\uff01");
            }
            BatInstBatch batchInst = BatchDataUtil.getBatInstBatch(conn, this.batchId);
            if (batchInst == null) {
                throw new Exception("\u672a\u627e\u5230\u91cd\u8dd1\u7684\u6279\u6b21\uff01");
            }
            String batchState = batchInst.getBatchState();
            if ("3".equals(batchState) || "8".equals(batchState)) {
                throw new Exception("\u6279\u6b21\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u91cd\u8dd1\uff01");
            }
            String cond = " where batch_id = '" + this.batchId + "'";
            this.dataMove(conn, "bat_inst_batch", "bat_inst_batch_h", cond);
            this.dataMove(conn, "bat_inst_task", "bat_inst_task_h", cond);
            String condi1 = " where batch_id = '" + this.batchId + "'";
            TableMove batchDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "bat_inst_batch", "bat_inst_batch");
            batchDataMoveUtil.setCondition(condi1);
            String batchSerialNo = batchInst.getBatchSerialNo();
            String lastTwoSerial = batchSerialNo.substring(batchSerialNo.length() - 1, batchSerialNo.length());
            lastTwoSerial = Integer.parseInt(lastTwoSerial) < 10 ? "0" + (Integer.parseInt(lastTwoSerial) + 1) : "" + (Integer.parseInt(lastTwoSerial) + 1);
            batchSerialNo = batchSerialNo.substring(0, batchSerialNo.length() - 2) + lastTwoSerial;
            batchDataMoveUtil.addValueMapping("batch_serial_no", batchSerialNo);
            batchDataMoveUtil.addValueMapping("batch_order", batchInst.getBatchOrder() + 1);
            batchDataMoveUtil.executeCopy();
            String condi = " where batch_id = '" + this.batchId + "' and task_use_state='0' and (task_use_area = '1' or task_use_area = '3') ";
            TableMove taskDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "bat_task_unit_config", "bat_inst_task");
            taskDataMoveUtil.setCondition(condi);
            taskDataMoveUtil.executeCopy();
            BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ConnectionUtil.releaseConnection(conn);
        }
    }

    private void doContinueBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BatInstTaskDao taskInstDao = new BatInstTaskDao(conn);
            taskInstDao.resetFaildTask(this.batchId);
            BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public void dataMove(Connection conn, String srcTableName, String destTableName, String cond) throws SQLException {
        TableMove dataMoveInst = DataMoveUtil.createTableMoveInst(conn, srcTableName, destTableName);
        dataMoveInst.setCondition(cond);
        dataMoveInst.executeCut();
    }
}

