/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.dao;

import com.irdstudio.bsp.executor.core.dao.domain.MigrateDictMapping;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MigrateDictMappingDao {
    Connection conn = null;

    public MigrateDictMappingDao(Connection conn) {
        this.conn = conn;
    }

    public int insertMigrateDictMapping(MigrateDictMapping migrateDictMapping) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into migrate_dict_mapping ( mapping_id,relation_id,source_option_code,source_option_name,target_option_code,target_option_name) values (?,?,?,?,?,?)");
            ps.setObject(1, migrateDictMapping.getMappingId());
            ps.setObject(2, migrateDictMapping.getRelationId());
            ps.setObject(3, migrateDictMapping.getSourceOptionCode());
            ps.setObject(4, migrateDictMapping.getSourceOptionName());
            ps.setObject(5, migrateDictMapping.getTargetOptionCode());
            ps.setObject(6, migrateDictMapping.getTargetOptionName());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert MigrateDictMapping is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteByPk(MigrateDictMapping migrateDictMapping) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("delete from migrate_dict_mapping where 1=1 AND mapping_id = ? ");
            ps.setObject(1, migrateDictMapping.getMappingId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("delete MigrateDictMapping is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int updateByPk(MigrateDictMapping migrateDictMapping) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("update migrate_dict_mapping set  mapping_id = ? , relation_id = ? , source_option_code = ? , source_option_name = ? , target_option_code = ? , target_option_name = ?  where 1=1 AND mapping_id = ? ");
            ps.setObject(1, migrateDictMapping.getMappingId());
            ps.setObject(2, migrateDictMapping.getRelationId());
            ps.setObject(3, migrateDictMapping.getSourceOptionCode());
            ps.setObject(4, migrateDictMapping.getSourceOptionName());
            ps.setObject(5, migrateDictMapping.getTargetOptionCode());
            ps.setObject(6, migrateDictMapping.getTargetOptionName());
            ps.setObject(7, migrateDictMapping.getMappingId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("update MigrateDictMapping is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public MigrateDictMapping queryByPk(MigrateDictMapping migrateDictMapping) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        MigrateDictMapping result = null;
        try {
            ps = this.conn.prepareStatement("select mapping_id,relation_id,source_option_code,source_option_name,target_option_code,target_option_namefrom migrate_dict_mapping where 1=1  AND mapping_id = ? ");
            ps.setObject(1, migrateDictMapping.getMappingId());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new MigrateDictMapping();
                result.setMappingId(rs.getString("mapping_id"));
                result.setRelationId(rs.getString("relation_id"));
                result.setSourceOptionCode(rs.getString("source_option_code"));
                result.setSourceOptionName(rs.getString("source_option_name"));
                result.setTargetOptionCode(rs.getString("target_option_code"));
                result.setTargetOptionName(rs.getString("target_option_name"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update MigrateDictMapping is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<MigrateDictMapping> queryAll(MigrateDictMapping migrateDictMapping) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<MigrateDictMapping> result = new ArrayList<MigrateDictMapping>();
        try {
            String sql = "select mapping_id,relation_id,source_option_code,source_option_name,target_option_code,target_option_namefrom migrate_dict_mapping where 1=1 ";
            if (migrateDictMapping.getMappingId() != null) {
                sql = sql + " AND mapping_id =  '" + migrateDictMapping.getMappingId() + "'";
            }
            if (migrateDictMapping.getRelationId() != null) {
                sql = sql + " AND relation_id =  '" + migrateDictMapping.getRelationId() + "'";
            }
            if (migrateDictMapping.getSourceOptionCode() != null) {
                sql = sql + " AND source_option_code =  '" + migrateDictMapping.getSourceOptionCode() + "'";
            }
            if (migrateDictMapping.getSourceOptionName() != null) {
                sql = sql + " AND source_option_name =  '" + migrateDictMapping.getSourceOptionName() + "'";
            }
            if (migrateDictMapping.getTargetOptionCode() != null) {
                sql = sql + " AND target_option_code =  '" + migrateDictMapping.getTargetOptionCode() + "'";
            }
            if (migrateDictMapping.getTargetOptionName() != null) {
                sql = sql + " AND target_option_name =  '" + migrateDictMapping.getTargetOptionName() + "'";
            }
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                MigrateDictMapping obj = new MigrateDictMapping();
                obj.setMappingId(rs.getString("mapping_id"));
                obj.setRelationId(rs.getString("relation_id"));
                obj.setSourceOptionCode(rs.getString("source_option_code"));
                obj.setSourceOptionName(rs.getString("source_option_name"));
                obj.setTargetOptionCode(rs.getString("target_option_code"));
                obj.setTargetOptionName(rs.getString("target_option_name"));
                result.add(obj);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update MigrateDictMapping is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

