/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin;

import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoUtil {
    private static final Logger logger = LoggerFactory.getLogger(DaoUtil.class);

    public static Collection<Map<String, String>> executeQuery(String sql, Object[] params, Connection con) throws Exception {
        ArrayList<Map<String, String>> arrayList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ResultSetMetaData rm = null;
        try {
            ps = con.prepareStatement(sql);
            ps.clearParameters();
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            rm = rs.getMetaData();
            ArrayList<Map<String, String>> col = new ArrayList<Map<String, String>>();
            while (rs.next()) {
                HashMap<String, String> mp = new HashMap<String, String>();
                for (int i = 1; i <= rm.getColumnCount(); ++i) {
                    if (2004 == rm.getColumnType(i)) {
                        mp.put(rm.getColumnName(i).toLowerCase(), DaoUtil.blob2String(rs.getBlob(i)));
                        continue;
                    }
                    if (2005 == rm.getColumnType(i)) {
                        mp.put(rm.getColumnName(i).toLowerCase(), DaoUtil.clob2String(rs.getClob(i)));
                        continue;
                    }
                    mp.put(rm.getColumnName(i).toLowerCase(), rs.getString(i));
                }
                col.add(mp);
            }
            arrayList = col;
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DaoUtil.close(rs, null, ps);
                throw throwable;
            }
        }
        DaoUtil.close(rs, null, ps);
        return arrayList;
    }

    public static Map<String, String> getFirstRecord(String sql, Object[] params, Connection con) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> mp = null;
        try {
            ps = con.prepareStatement(sql);
            ps.clearParameters();
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData rm = rs.getMetaData();
            mp = new HashMap<String, String>();
            if (rs.next()) {
                for (int i = 1; i <= rm.getColumnCount(); ++i) {
                    if (2004 == rm.getColumnType(i)) {
                        mp.put(rm.getColumnName(i).toLowerCase(), DaoUtil.blob2String(rs.getBlob(i)));
                        continue;
                    }
                    mp.put(rm.getColumnName(i).toLowerCase(), rs.getString(i));
                }
            }
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DaoUtil.close(rs, null, ps);
                throw throwable;
            }
        }
        DaoUtil.close(rs, null, ps);
        return mp;
    }

    public static boolean execute(String sql, Object[] params, Connection con) throws Exception {
        PreparedStatement ps = null;
        try {
            int i;
            ps = con.prepareStatement(sql);
            ps.clearParameters();
            if (params != null && params.length > 0) {
                for (i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            i = ps.execute();
            return i != 0;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            DaoUtil.close(null, null, ps);
        }
    }

    public static int executeUpdate(String sql, Object[] params, Connection con) throws Exception {
        PreparedStatement ps = null;
        try {
            int i;
            ps = con.prepareStatement(sql);
            ps.clearParameters();
            if (params != null && params.length > 0) {
                for (i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            i = ps.executeUpdate();
            return i;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            DaoUtil.close(null, null, ps);
        }
    }

    public static String blob2String(Blob blob) {
        if (null == blob) {
            return "";
        }
        String str = "";
        try {
            str = new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return str;
    }

    public static String clob2String(Clob clob) throws Exception {
        if (null == clob) {
            return "";
        }
        String content = "";
        StringBuilder sb = new StringBuilder();
        Reader inStream = null;
        BufferedReader bfRead = null;
        try {
            inStream = clob.getCharacterStream();
            bfRead = new BufferedReader(inStream);
            String s = bfRead.readLine();
            while (s != null) {
                sb.append(s);
                s = bfRead.readLine();
            }
            content = sb.toString();
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bfRead != null) {
                    bfRead.close();
                }
            }
            catch (Exception exception) {}
        }
        return content;
    }

    public static void close(ResultSet rs, Statement s, PreparedStatement ps) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (s != null) {
                s.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

