/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.check;

import com.irdstudio.bsp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bsp.executor.core.plugin.check.PluginCheckConf;
import com.irdstudio.bsp.executor.core.plugin.check.PluginCheckConfDao;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DataCheckPlugin
extends AbstractPlugin {
    private List<PluginCheckConf> checkList;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginCheckConfDao checkDao = new PluginCheckConfDao(conn);
        this.checkList = checkDao.queryPluginCheckConfWithPluginConfId(szConfIdentify);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getPluginConnection();
            st = conn.createStatement();
            for (int i = 0; i < this.checkList.size(); ++i) {
                PluginCheckConf pcc = this.checkList.get(i);
                if (this.isInValidConf(this.context.getCurrentDataDate(), pcc.getValidDate(), pcc.getInvalidDate())) continue;
                this.logger.info("........................................................................");
                this.logger.info("\u51c6\u5907\u6267\u884c\u68c0\u67e5\uff1a" + pcc.getCheckItemName() + "...");
                String sql = this.context.toParseSysVariable(pcc.getCheckItemSql());
                this.logger.info(sql);
                boolean bCheckFlag = false;
                try (ResultSet rs = st.executeQuery(sql);){
                    if (rs.next()) {
                        String[] exps = this.parseExpression(pcc.getCheckSucCondition());
                        if (exps == null) {
                            this.writeFaildLog("\u6210\u529f\u6761\u4ef6\u914d\u7f6e\u6709\u8bef!");
                            bCheckFlag = false;
                        } else {
                            bCheckFlag = this.isSuccess(rs.getString(exps[0]), exps);
                            if (!bCheckFlag) {
                                this.context.setSzLastErrorMsg(this.context.toParseFieldVariable(pcc.getCheckErrDesc(), rs) + this.context.getSzLastErrorMsg());
                            }
                        }
                    } else {
                        this.writeFaildLog("\u68c0\u67e5\u8bed\u53e5\u67e5\u51fa\u6765\u7684\u8bb0\u5f55\u6570\u4e3a\u96f6\uff0c\u65e0\u6cd5\u6bd4\u8f83!", sql);
                    }
                }
                if (bCheckFlag) {
                    this.writeSuccessLog("\u6267\u884c\u68c0\u67e5:" + pcc.getCheckItemName(), sql);
                    continue;
                }
                this.writeFaildLog("\u6267\u884c\u68c0\u67e5:" + pcc.getCheckItemName(), sql + ";" + this.context.getSzLastErrorMsg());
                if ("1".equals(pcc.getCheckFaildDeal())) continue;
                flag = false;
                break;
            }
        }
        catch (SQLException e) {
            flag = false;
            this.context.setSzLastErrorMsg(e.getMessage());
        }
        finally {
            this.close(null, st, null);
            this.closePluginConnection(conn);
        }
        return flag;
    }
}

