/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.dataexport;

import com.irdstudio.bsp.executor.core.plugin.dataexport.DataExportExecutor;
import com.irdstudio.bsp.executor.core.plugin.dataexport.PluginExportConf;
import com.irdstudio.bsp.executor.core.tinycore.log.ILogger;
import java.sql.Connection;
import java.util.concurrent.Callable;

public class DataExportCallable
implements Callable<Boolean> {
    private PluginExportConf exportConf = null;
    private Connection conn = null;
    private ILogger logger = null;

    public DataExportCallable() {
    }

    public DataExportCallable(PluginExportConf exportConf, Connection conn, ILogger logger) {
        this.conn = conn;
        this.exportConf = exportConf;
        this.logger = logger;
    }

    @Override
    public Boolean call() throws Exception {
        boolean flag = true;
        long startTime = System.currentTimeMillis();
        try {
            String exportToFile = this.exportConf.getExportToFile();
            this.logger.info("\u7ebf\u7a0b[" + Thread.currentThread().getName() + "]\u6267\u884c\u62c6\u5206\u5bfc\u51fa\u6570\u636e[" + exportToFile + "]");
            DataExportExecutor dataExport = new DataExportExecutor(this.exportConf, this.conn, this.logger);
            flag = dataExport.run();
        }
        catch (Exception e) {
            flag = false;
            throw new Exception(e);
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
            this.logger.info("\u7ebf\u7a0b[" + Thread.currentThread().getName() + "]\u6267\u884c\u62c6\u5206\u5bfc\u51fa\u7ed3\u675f[" + flag + "],\u7528\u65f6[" + (System.currentTimeMillis() - startTime) / 1000L + "\u79d2]\u3002");
        }
        return flag;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public PluginExportConf getExportConf() {
        return this.exportConf;
    }

    public void setExportConf(PluginExportConf exportConf) {
        this.exportConf = exportConf;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }
}

