/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.rest.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static ThreadLocal<DateFormat> THREADLOCAL_YCLOANS_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        }
    };

    public static String getNextDay(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.ENGLISH);
        dateFormat.setLenient(false);
        Date timeDate = dateFormat.parse(date);
        Date next = org.apache.commons.lang3.time.DateUtils.addDays((Date)timeDate, (int)1);
        return dateFormat.format(next);
    }

    public static String getDateStringByMonth(String dateString, int monthAmount) {
        String[] sday = dateString.split("-");
        Calendar rsCalendar = Calendar.getInstance();
        rsCalendar.setTime(DateUtils.getDateFromDbString(dateString));
        rsCalendar.add(2, monthAmount);
        int maxDay = rsCalendar.getActualMaximum(5);
        int dayCount = Integer.parseInt(sday[2]) > maxDay ? maxDay : Integer.parseInt(sday[2]);
        rsCalendar.set(5, dayCount);
        return DateUtils.getDateStringToDb(rsCalendar.getTime());
    }

    public static Date getDateFromDbString(String dateString) {
        try {
            return THREADLOCAL_YCLOANS_FORMAT.get().parse(dateString);
        }
        catch (ParseException e) {
            logger.error("getDateFromDbString\u65b9\u6cd5\u6267\u884c\u51fa\u9519", (Throwable)e);
            throw new IllegalArgumentException("string format error!!");
        }
    }

    public static String getDateStringToDb(Date date) {
        return THREADLOCAL_YCLOANS_FORMAT.get().format(date);
    }

    public static String getFirstDayofNextMonth(String openDay, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            Date date = sdf.parse(openDay);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(5, 1);
            calendar.add(2, 1);
            return sdf.format(calendar.getTime());
        }
        catch (Exception e) {
            logger.error("getFirstDayofNextMonth\u65b9\u6cd5\u6267\u884c\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public static String getDateIncDayCount(String inputDate, int dayCount) {
        Date d = DateUtils.getDateFromDbString(inputDate);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(6, dayCount);
        return DateUtils.getDateStringToDb(c.getTime());
    }

    public static final int getDaysBetween(String d1Str, String d2Str) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date d1 = new Date();
        Date d2 = new Date();
        try {
            d1 = df.parse(d1Str);
            d2 = df.parse(d2Str);
        }
        catch (ParseException e) {
            logger.error("getDaysBetween\u65b9\u6cd5\u6267\u884c\u51fa\u9519", (Throwable)e);
        }
        return DateUtils.getDaysBetween(d1, d2);
    }

    public static final int getDaysBetween(Date d1, Date d2) {
        return DateUtils.getDaysBetween(DateUtils.date2Calendar(d1), DateUtils.date2Calendar(d2));
    }

    public static final int getDaysBetween(Calendar d1, Calendar d2) {
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    public static final Calendar date2Calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

