/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.console.common.psd;

import org.apache.commons.lang3.StringUtils;

public class PsdTmUtils {
    public static String cusNameTm(String cusName) {
        if (StringUtils.isBlank((CharSequence)cusName)) {
            return cusName;
        }
        return StringUtils.join((Object[])new String[]{StringUtils.left((String)cusName, (int)1), "**"});
    }

    public static String certCodeTm(String certCode) {
        if (StringUtils.isBlank((CharSequence)certCode)) {
            return certCode;
        }
        if (certCode.length() == 15) {
            return certCode.replaceAll("(\\w{4})\\w*(\\w{4})", "$1*******$2");
        }
        if (certCode.length() == 18) {
            return certCode.replaceAll("(\\w{4})\\w*(\\w{4})", "$1**********$2");
        }
        return certCode;
    }

    public static String addrTm(String addr) {
        if (StringUtils.isBlank((CharSequence)addr)) {
            return addr;
        }
        int len = addr.length();
        int keepLen = (int)Math.ceil(len / 2);
        String left = StringUtils.left((String)addr, (int)keepLen);
        for (int i = 0; i < len - keepLen; ++i) {
            left = left.concat("*");
        }
        return left;
    }

    public static String mobileTm(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return mobile;
        }
        return mobile.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
    }

    public static String accountTm(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return account;
        }
        int len = account.length();
        String starStr = "";
        for (int i = 0; i < len - 8; ++i) {
            starStr = starStr.concat("*");
        }
        return account.replaceAll("(\\w{4})\\w*(\\w{4})", StringUtils.join((Object[])new String[]{"$1", starStr, "$2"}));
    }
}

