/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.console.common.util;

import com.irdstudio.basic.framework.core.util.ReflectUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.efp.console.common.annotation.ExcelField;
import com.irdstudio.efp.console.common.annotation.ExcelSheet;
import com.irdstudio.efp.console.common.util.FieldReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportUtil.class);

    public static List<Object> importExcel(Workbook workbook, Class<?> sheetClass) throws Exception {
        List<Object> sheetDataList = ExcelImportUtil.importSheet(workbook, sheetClass);
        return sheetDataList;
    }

    public static <T> List<T> importExcelByClass(Workbook workbook, Class<?> sheetClass) throws Exception {
        List<T> sheetDataList = ExcelImportUtil.importSheetByClass(workbook, sheetClass);
        return sheetDataList;
    }

    public static <T> List<T> importSheetByClass(Workbook workbook, Class<?> sheetClass) throws Exception {
        try {
            ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
            String sheetName = excelSheet != null && excelSheet.name() != null && excelSheet.name().trim().length() > 0 ? excelSheet.name().trim() : sheetClass.getSimpleName();
            ArrayList<Field> fields = new ArrayList<Field>();
            if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
                for (Field field : sheetClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    fields.add(field);
                }
            }
            if (fields.isEmpty()) {
                throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
            }
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new Exception("\u8bf7\u5c06\u5bfc\u5165\u6570\u636e\u7684sheet\u540d\u79f0\u4fee\u6539\u4e3a\u201c\u6240\u5c5e\u5730\u5e02\u6620\u5c04\u201d\uff01");
            }
            Iterator sheetIterator = sheet.rowIterator();
            int rowIndex = 0;
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (sheetIterator.hasNext()) {
                Row rowX = (Row)sheetIterator.next();
                if (rowIndex > 0) {
                    Object rowObj = null;
                    for (int i = 0; i < fields.size(); ++i) {
                        ExcelField excel;
                        Field field;
                        Object fieldValue;
                        Cell cell = rowX.getCell(i);
                        if (cell == null) continue;
                        cell.setCellType(CellType.STRING);
                        String fieldValueStr = cell.getStringCellValue();
                        if (!StringUtil.isNotEmpty((String)fieldValueStr) || (fieldValue = FieldReflectionUtil.parseValue(field = (Field)fields.get(i), fieldValueStr)) == null) continue;
                        if (rowObj == null) {
                            rowObj = sheetClass.newInstance();
                        }
                        if (StringUtil.isNotEmpty((String)(excel = field.getDeclaredAnnotation(ExcelField.class)).dicType()) && fieldValue.toString().indexOf("-") < 0) {
                            throw new Exception("\u8f93\u5165\u7684\u683c\u5f0f\u5e94\u4e3akey-value!");
                        }
                        if (StringUtil.isNotEmpty((String)excel.dicType()) && fieldValue.toString().indexOf("-") >= 0) {
                            fieldValue = fieldValue.toString().split("-")[0];
                        }
                        ReflectUtility.setObjectFieldValue(rowObj, (Field)field, (Object)fieldValue);
                    }
                    if (rowObj != null) {
                        dataList.add(rowObj);
                    }
                }
                ++rowIndex;
            }
            return dataList;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importSheet(Workbook workbook, Class<?> sheetClass) throws Exception {
        try {
            ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
            String sheetName = excelSheet != null && excelSheet.name() != null && excelSheet.name().trim().length() > 0 ? excelSheet.name().trim() : sheetClass.getSimpleName();
            ArrayList<Field> fields = new ArrayList<Field>();
            if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
                for (Field field : sheetClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    fields.add(field);
                }
            }
            if (fields.isEmpty()) {
                throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
            }
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new Exception("\u8bf7\u5c06\u5bfc\u5165\u6570\u636e\u7684sheet\u540d\u79f0\u4fee\u6539\u4e3asheet1");
            }
            Iterator sheetIterator = sheet.rowIterator();
            int rowIndex = 0;
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (sheetIterator.hasNext()) {
                Row rowX = (Row)sheetIterator.next();
                if (rowIndex > 0) {
                    Object rowObj = null;
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field;
                        Object fieldValue;
                        Cell cell = rowX.getCell(i);
                        if (cell == null) continue;
                        cell.setCellType(CellType.STRING);
                        String fieldValueStr = cell.getStringCellValue();
                        if (!StringUtil.isNotEmpty((String)fieldValueStr) || (fieldValue = FieldReflectionUtil.parseValue(field = (Field)fields.get(i), fieldValueStr)) == null) continue;
                        if (rowObj == null) {
                            rowObj = sheetClass.newInstance();
                        }
                        ReflectUtility.setObjectFieldValue(rowObj, (Field)field, (Object)fieldValue);
                    }
                    if (rowObj != null) {
                        dataList.add(rowObj);
                    }
                }
                ++rowIndex;
            }
            return dataList;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importExcel(File excelFile, Class<?> sheetClass) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            List<Object> dataList = ExcelImportUtil.importExcel(workbook, sheetClass);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> importExcelByClass(File excelFile, Class<?> sheetClass) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            List<T> dataList = ExcelImportUtil.importExcelByClass(workbook, sheetClass);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importExcel(String filePath, Class<?> sheetClass) throws Exception {
        File excelFile = new File(filePath);
        List<Object> dataList = ExcelImportUtil.importExcel(excelFile, sheetClass);
        return dataList;
    }

    public static List<Object> importExcel(InputStream inputStream, Class<?> sheetClass) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            List<Object> dataList = ExcelImportUtil.importExcel(workbook, sheetClass);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

