/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.common.client.req.EsbReqAppHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqServiceBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.service.client.ESBBeanCreator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class DefaultESBBeanCreator
implements ESBBeanCreator {
    private static final DefaultESBBeanCreator INSTANCE = new DefaultESBBeanCreator();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);
    private static DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter timeForm = DateTimeFormatter.ofPattern("HHmmss");

    @Override
    public EsbReqServiceBean create(String serverCode, String scene, Object body) throws Exception {
        EsbReqSysHeadBean sysHead = this.buildSysHead(serverCode, scene);
        EsbReqAppHeadBean appHead = this.buildAppHead();
        EsbReqServiceBean reqBean = new EsbReqServiceBean();
        reqBean.setAppHead(appHead);
        reqBean.setSysHead(sysHead);
        reqBean.setBODY(body);
        return reqBean;
    }

    public static DefaultESBBeanCreator getINSTANCE() {
        return INSTANCE;
    }

    protected EsbReqSysHeadBean buildSysHead(String serverCode, String scene) throws Exception {
        EsbReqSysHeadBean syshead = new EsbReqSysHeadBean();
        syshead.setSvcCd(serverCode);
        syshead.setScnCd(scene);
        syshead.setCnsmrSysID("2003000");
        String globalSrlNo = TraceUtil.getTraceId();
        String consumerSrlNo = this.generateESBTradeSerialNo();
        syshead.setGlblSrlNo(globalSrlNo == null ? consumerSrlNo : globalSrlNo);
        syshead.setCnsmrSrlNo(this.generateESBTradeSerialNo());
        syshead.setOrgnlCnsmrSysID(globalSrlNo == null ? consumerSrlNo.substring(0, 7) : globalSrlNo.substring(0, 7));
        LocalDateTime date = LocalDateTime.now();
        syshead.setTxnDt(dateForm.format(date));
        syshead.setTxnTm(timeForm.format(date));
        syshead.setTxnMd(ESBClientConstance.TxnMd.ONLINE.name());
        syshead.setUsrLng(ESBClientConstance.UsrLng.CHINESE.name());
        syshead.setFileFlg(ESBClientConstance.FileFlg.NONE.VALUE);
        syshead.setEryptMd(ESBClientConstance.EryptMd.NONE.VALUE);
        syshead.setPlafmID(TraceUtil.getPlafmID());
        syshead.setPlafmUsrID(TraceUtil.getPlafmUsrID());
        syshead.setCompany("GCB");
        syshead.setInstId(TraceUtil.getInstId());
        syshead.setOrgnlTmlIdNo("");
        syshead.setTmlIdNo("");
        syshead.setOrgnlCnsmrSvcNo("");
        syshead.setCnsmrSvcNo("");
        syshead.setMACVal("");
        syshead.setMACFctr("");
        syshead.setPINSd("");
        syshead.setSvcVerNo("");
        syshead.setVerfFlg("");
        syshead.setMsgTp("");
        syshead.setPltfmClntNo("");
        syshead.setPrdctID("");
        syshead.setRelGlblSrlNo("");
        return syshead;
    }

    protected EsbReqAppHeadBean buildAppHead() {
        EsbReqAppHeadBean appHead = new EsbReqAppHeadBean();
        String instId = TraceUtil.getInstId() == null ? "" : TraceUtil.getInstId();
        appHead.setInstId(instId);
        appHead.setUsrNo(TraceUtil.getUsrNo() == null ? "98135" : TraceUtil.getUsrNo());
        appHead.setCnlTp(TraceUtil.getCnlTp() == null ? "843" : TraceUtil.getCnlTp());
        appHead.setUsrPswd("");
        appHead.setUsrLvl("");
        appHead.setUsrTp("");
        appHead.setTlrSrlNo("");
        appHead.setUsrTp("");
        appHead.setCnlDtlTp("");
        appHead.setCnsmrTxnCd("");
        return appHead;
    }

    private String generateESBTradeSerialNo() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("ESB", pattern);
    }
}

