/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.efp.esb.common.client.req.EsbReqServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.util.JsonLogUtil;
import com.irdstudio.efp.esb.service.client.ESBBeanCreator;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.client.ESBConfig;
import com.irdstudio.efp.esb.service.client.HttpClientFactory;
import com.irdstudio.efp.esb.service.client.impl.ESBClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class ESBClientImpl
implements ESBClient {
    private final Object sendBodyBean;
    private final String tradeNo;
    private final String scene;
    private final HttpClientFactory httpClientFactory;
    private final ESBConfig config;
    private final ESBBeanCreator creator;
    private static final Logger log = LoggerFactory.getLogger(ESBClientImpl.class);

    public ESBClientImpl(ESBClientFactory.Builder builder) {
        this.sendBodyBean = Objects.requireNonNull(builder.getToSend());
        this.tradeNo = Objects.requireNonNull(builder.getTradeNo());
        this.scene = Objects.requireNonNull(builder.getScene());
        this.httpClientFactory = Objects.requireNonNull(builder.getFactory());
        this.config = Objects.requireNonNull(builder.getConfig());
        this.creator = Objects.requireNonNull(builder.getESBBeanFactory());
    }

    @Override
    public EsbRespServiceBean sendAndReceive() throws ESBException {
        try {
            EsbReqServiceBean clientBean = this.creator.create(this.tradeNo, this.scene, this.sendBodyBean);
            log.info(JSONObject.toJSONString((Object)clientBean));
            String recvJson = this.doSend(clientBean, this.config.getUrl());
            String logJson = new String(recvJson);
            logJson = JsonLogUtil.changeJSONStrWithBody((String)logJson, (String)"ContrFlStrm");
            log.info("\u63a5\u6536\u5230Json\uff1a" + logJson);
            EsbRespServiceBean recvBean = (EsbRespServiceBean)JSONObject.parseObject((String)recvJson, EsbRespServiceBean.class);
            List array = Optional.ofNullable(recvBean.getSysHead()).map(EsbRespSysHeadBean::getRetInfArry).orElseGet(ArrayList::new);
            if (array.stream().map(EsbRespRetInfBean::getRetCd).filter(Objects::nonNull).anyMatch(i -> i.startsWith("ESB"))) {
                String errorMsg = "ESB\u63a5\u53e3\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f\u6570\u7ec4\uff1a" + array;
                throw new ESBException(errorMsg);
            }
            return recvBean;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ESBException((Throwable)e);
        }
    }

    private String doSend(EsbReqServiceBean clientBean, String url) {
        String sendJson = JSONObject.toJSONString((Object)clientBean, (SerializeFilter)new PascalNameFilter(), (SerializerFeature[])new SerializerFeature[0]);
        String logJson = JSONObject.toJSONString((Object)clientBean, (SerializeFilter)new PascalNameFilter(), (SerializerFeature[])new SerializerFeature[0]);
        logJson = JsonLogUtil.changeJSONStrWithBody((String)logJson, (String)"ContrFlStrm");
        log.info("\u53d1\u9001Json: " + logJson + ",ESB\u76ee\u6807url:" + url);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity entity = new HttpEntity((Object)sendJson, (MultiValueMap)headers);
        ResponseEntity recvEntity = this.httpClientFactory.getClient().exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
        return (String)recvEntity.getBody();
    }
}

