/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.common.client.req.EsbReqAppHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.service.client.impl.DefaultESBBeanCreator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="HEDESBBeanCreator")
public class HEDESBBeanCreator
extends DefaultESBBeanCreator {
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);
    private static DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter timeForm = DateTimeFormatter.ofPattern("HHmmss");
    @Value(value="${esb.client.hed.usrno}")
    private String usrno;
    private String msgTp;
    private String glblSrlNo;
    private String InstId;
    private String CnlTp;
    private String PlafmID;
    private String PlafmUsrID;

    public String getGlblSrlNo() {
        return this.glblSrlNo;
    }

    public void setGlblSrlNo(String glblSrlNo) {
        this.glblSrlNo = glblSrlNo;
    }

    public String getInstId() {
        return this.InstId;
    }

    public void setInstId(String instId) {
        this.InstId = instId;
    }

    public String getCnlTp() {
        return this.CnlTp;
    }

    public void setCnlTp(String cnlTp) {
        this.CnlTp = cnlTp;
    }

    public String getPlafmID() {
        return this.PlafmID;
    }

    public void setPlafmID(String plafmID) {
        this.PlafmID = plafmID;
    }

    public String getPlafmUsrID() {
        return this.PlafmUsrID;
    }

    public void setPlafmUsrID(String plafmUsrID) {
        this.PlafmUsrID = plafmUsrID;
    }

    @PostConstruct
    public void test() {
        System.out.println(this.usrno);
    }

    @DisconfItem(key="esb.client.hed.usrno", associateField="usrno")
    public String getUsrno() {
        return this.usrno;
    }

    public void setUsrno(String usrno) {
        this.usrno = usrno;
    }

    public String getMsgTp() {
        return this.msgTp;
    }

    public void setMsgTp(String msgTp) {
        this.msgTp = msgTp;
    }

    @Override
    protected EsbReqAppHeadBean buildAppHead() {
        EsbReqAppHeadBean appHead = new EsbReqAppHeadBean();
        appHead.setInstId(this.InstId);
        appHead.setCnlTp(this.CnlTp);
        appHead.setUsrNo(this.usrno);
        appHead.setUsrPswd("");
        appHead.setUsrLvl("");
        appHead.setUsrTp("");
        appHead.setTlrSrlNo("");
        appHead.setCnlDtlTp("");
        appHead.setCnsmrTxnCd("");
        return appHead;
    }

    @Override
    protected EsbReqSysHeadBean buildSysHead(String serverCode, String scene) throws Exception {
        EsbReqSysHeadBean syshead = new EsbReqSysHeadBean();
        syshead.setSvcCd(serverCode);
        syshead.setScnCd(scene);
        syshead.setCnsmrSysID("2003000");
        syshead.setOrgnlCnsmrSysID("2003000");
        String consumerSrlNo = this.generateESBTradeSerialNo();
        syshead.setGlblSrlNo(this.glblSrlNo == null ? consumerSrlNo : this.glblSrlNo);
        syshead.setOrgnlCnsmrSysID(this.glblSrlNo == null ? consumerSrlNo.substring(0, 7) : this.glblSrlNo.substring(0, 7));
        syshead.setCnsmrSrlNo(consumerSrlNo);
        LocalDateTime date = LocalDateTime.now();
        syshead.setTxnDt(dateForm.format(date));
        syshead.setTxnTm(timeForm.format(date));
        syshead.setTxnMd(ESBClientConstance.TxnMd.ONLINE.name());
        syshead.setUsrLng(ESBClientConstance.UsrLng.CHINESE.name());
        syshead.setFileFlg(ESBClientConstance.FileFlg.NONE.VALUE);
        syshead.setEryptMd(ESBClientConstance.EryptMd.NONE.VALUE);
        syshead.setPlafmID(this.PlafmID);
        syshead.setPlafmUsrID(this.PlafmUsrID);
        syshead.setCompany("GCB");
        syshead.setOrgnlTmlIdNo("");
        syshead.setTmlIdNo("");
        syshead.setOrgnlCnsmrSvcNo("");
        syshead.setCnsmrSvcNo("");
        syshead.setMACVal("");
        syshead.setMACFctr("");
        syshead.setPINSd("");
        syshead.setSvcVerNo("");
        syshead.setVerfFlg("");
        if (StringUtils.isNotBlank((CharSequence)this.msgTp)) {
            syshead.setMsgTp(this.msgTp);
        } else {
            syshead.setMsgTp("");
        }
        syshead.setPltfmClntNo("");
        syshead.setPrdctID("");
        syshead.setRelGlblSrlNo("");
        return syshead;
    }

    private String generateESBTradeSerialNo() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("ESB", pattern);
    }
}

