/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.common.client.req.EsbReqAppHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqServiceBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.service.client.EsbBaseBean;
import com.irdstudio.efp.esb.service.client.REsbBeanCreator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceESBBeanCreator
implements REsbBeanCreator {
    private static final REsbBeanCreator INSTANCE = new ReferenceESBBeanCreator();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);
    private static final Logger log = LoggerFactory.getLogger(ReferenceESBBeanCreator.class);
    private static DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter timeForm = DateTimeFormatter.ofPattern("HHmmss");

    @Override
    public EsbReqServiceBean create(String serverCode, String scene, EsbBaseBean esbBaseBean, Object body) throws Exception {
        EsbReqSysHeadBean sysHead = this.buildSysHead(serverCode, scene, esbBaseBean);
        EsbReqAppHeadBean appHead = this.buildAppHead(esbBaseBean);
        EsbReqServiceBean reqBean = new EsbReqServiceBean();
        reqBean.setAppHead(appHead);
        reqBean.setSysHead(sysHead);
        reqBean.setBODY(body);
        return reqBean;
    }

    public static REsbBeanCreator getINSTANCE() {
        return INSTANCE;
    }

    protected EsbReqSysHeadBean buildSysHead(String serverCode, String scene, EsbBaseBean esbBaseBean) throws Exception {
        EsbReqSysHeadBean syshead = new EsbReqSysHeadBean();
        syshead.setSvcCd(serverCode);
        syshead.setScnCd(scene);
        syshead.setCnsmrSysID("2003000");
        String tradeSerialNo = this.generateESBTradeSerialNo();
        syshead.setGlblSrlNo(StringUtils.isEmpty((CharSequence)esbBaseBean.getGLBLSRLNO()) ? tradeSerialNo : esbBaseBean.getGLBLSRLNO());
        syshead.setCnsmrSrlNo(this.generateESBTradeSerialNo());
        syshead.setOrgnlCnsmrSysID(StringUtils.isEmpty((CharSequence)esbBaseBean.getGLBLSRLNO()) ? tradeSerialNo.substring(0, 7) : esbBaseBean.getGLBLSRLNO().substring(0, 7));
        LocalDateTime date = LocalDateTime.now();
        syshead.setTxnDt(dateForm.format(date));
        syshead.setTxnTm(timeForm.format(date));
        syshead.setTxnMd(ESBClientConstance.TxnMd.ONLINE.name());
        syshead.setUsrLng(ESBClientConstance.UsrLng.CHINESE.name());
        syshead.setFileFlg(ESBClientConstance.FileFlg.NONE.VALUE);
        syshead.setEryptMd(ESBClientConstance.EryptMd.NONE.VALUE);
        syshead.setPlafmID(StringUtils.isEmpty((CharSequence)esbBaseBean.getPLATFMID()) ? "B00001" : esbBaseBean.getPLATFMID());
        syshead.setPlafmUsrID(StringUtils.isEmpty((CharSequence)esbBaseBean.getPLAFMUSRID()) ? "" : esbBaseBean.getPLAFMUSRID());
        syshead.setCompany("GCB");
        syshead.setOrgnlTmlIdNo("");
        syshead.setTmlIdNo("");
        syshead.setOrgnlCnsmrSvcNo("");
        syshead.setCnsmrSvcNo("");
        syshead.setMACVal("");
        syshead.setMACFctr("");
        syshead.setPINSd("");
        syshead.setSvcVerNo("");
        syshead.setVerfFlg("");
        syshead.setMsgTp(StringUtils.isEmpty((CharSequence)esbBaseBean.getMSGTP()) ? "" : esbBaseBean.getMSGTP());
        syshead.setPltfmClntNo("");
        syshead.setPrdctID("");
        syshead.setRelGlblSrlNo("");
        return syshead;
    }

    protected EsbReqAppHeadBean buildAppHead(EsbBaseBean esbBaseBean) {
        EsbReqAppHeadBean appHead = new EsbReqAppHeadBean();
        appHead.setInstId(esbBaseBean.getINSTID());
        appHead.setUsrNo(StringUtils.isEmpty((CharSequence)esbBaseBean.getUSRNO()) ? "90087" : esbBaseBean.getUSRNO());
        if (StringUtil.isNullorBank((String)esbBaseBean.getCNLTP())) {
            log.error("\u8bf7\u6c42\u5934\u6e20\u9053\u53f7\u4e3a\u7a7a\uff01");
        }
        appHead.setCnlTp(esbBaseBean.getCNLTP());
        appHead.setUsrPswd("");
        appHead.setUsrLvl("");
        appHead.setUsrTp("");
        appHead.setTlrSrlNo("");
        appHead.setUsrTp("");
        appHead.setCnlDtlTp("");
        appHead.setCnsmrTxnCd("");
        return appHead;
    }

    private String generateESBTradeSerialNo() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("ESB", pattern);
    }
}

