/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.esb.common.client.req.EsbReqAppHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.service.client.impl.DefaultESBBeanCreator;
import com.irdstudio.efp.nls.common.constant.PrdInfoEnum;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="WSDESBBeanCreator")
public class WSDESBBeanCreator
extends DefaultESBBeanCreator {
    @Value(value="${esb.client.bd.usrno}")
    private String usrno;
    private static final DefaultESBBeanCreator INSTANCE = new DefaultESBBeanCreator();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);
    private static DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter timeForm = DateTimeFormatter.ofPattern("HHmmss");

    @PostConstruct
    public void test() {
        System.out.println(this.usrno);
    }

    @DisconfItem(key="esb.client.bd.usrno", associateField="usrno")
    public String getUsrno() {
        return this.usrno;
    }

    public void setUsrno(String usrno) {
        this.usrno = usrno;
    }

    @Override
    protected EsbReqAppHeadBean buildAppHead() {
        EsbReqAppHeadBean appHead = new EsbReqAppHeadBean();
        appHead.setInstId(this.getWsdInstId());
        appHead.setUsrNo(this.usrno);
        appHead.setCnlTp("843");
        appHead.setUsrPswd("");
        appHead.setUsrLvl("");
        appHead.setUsrTp("");
        appHead.setTlrSrlNo("");
        appHead.setCnlDtlTp("");
        appHead.setCnsmrTxnCd("");
        return appHead;
    }

    @Override
    protected EsbReqSysHeadBean buildSysHead(String serverCode, String scene) throws Exception {
        EsbReqSysHeadBean syshead = new EsbReqSysHeadBean();
        syshead.setSvcCd(serverCode);
        syshead.setScnCd(scene);
        syshead.setCnsmrSysID("2003000");
        String globalSrlNo = TraceUtil.getTraceId();
        String consumerSrlNo = this.generateESBTradeSerialNo();
        syshead.setGlblSrlNo(globalSrlNo == null ? consumerSrlNo : globalSrlNo);
        syshead.setCnsmrSrlNo(this.generateESBTradeSerialNo());
        syshead.setOrgnlCnsmrSysID(globalSrlNo == null ? consumerSrlNo.substring(0, 7) : globalSrlNo.substring(0, 7));
        LocalDateTime date = LocalDateTime.now();
        syshead.setTxnDt(dateForm.format(date));
        syshead.setTxnTm(timeForm.format(date));
        syshead.setTxnMd(ESBClientConstance.TxnMd.ONLINE.name());
        syshead.setUsrLng(ESBClientConstance.UsrLng.CHINESE.name());
        syshead.setFileFlg(ESBClientConstance.FileFlg.NONE.VALUE);
        syshead.setEryptMd(ESBClientConstance.EryptMd.NONE.VALUE);
        syshead.setPlafmID(TraceUtil.getPlafmID());
        syshead.setPlafmUsrID(TraceUtil.getPlafmUsrID());
        syshead.setCompany("GCB");
        syshead.setOrgnlTmlIdNo("");
        syshead.setTmlIdNo("");
        syshead.setOrgnlCnsmrSvcNo("");
        syshead.setCnsmrSvcNo("");
        syshead.setMACVal("");
        syshead.setMACFctr("");
        syshead.setPINSd("");
        syshead.setSvcVerNo("");
        syshead.setVerfFlg("");
        syshead.setMsgTp("");
        syshead.setPltfmClntNo("");
        syshead.setPrdctID("");
        syshead.setRelGlblSrlNo("");
        return syshead;
    }

    private String generateESBTradeSerialNo() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("ESB", pattern);
    }

    private String getWsdInstId() {
        PrdInfoService service = (PrdInfoService)SpringContextUtils.getBean((String)"prdInfoService", PrdInfoService.class);
        PrdInfoVO vo = new PrdInfoVO();
        vo.setPrdId(PrdInfoEnum.WSD.getPrdId());
        PrdInfoVO qryInfo = service.queryByPk(vo);
        return StringUtil.isNullorBank((String)qryInfo.getOperateAgency()) ? "10368" : qryInfo.getOperateAgency();
    }
}

