/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.common.client.req.EsbReqAppHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.common.constant.InstitutionEnums;
import com.irdstudio.efp.esb.service.client.impl.DefaultESBBeanCreator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="YEDESBBeanCreator")
public class YEDESBBeanCreator
extends DefaultESBBeanCreator {
    private static final DefaultESBBeanCreator INSTANCE = new DefaultESBBeanCreator();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);
    private static DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter timeForm = DateTimeFormatter.ofPattern("HHmmss");
    @Value(value="${esb.client.yed.usrno}")
    private String usrno;
    private String msgTp;
    private String yedGlobalSerno;

    @PostConstruct
    public void test() {
        System.out.println(this.usrno);
    }

    @DisconfItem(key="esb.client.yed.usrno", associateField="usrno")
    public String getUsrno() {
        return this.usrno;
    }

    public void setUsrno(String usrno) {
        this.usrno = usrno;
    }

    public String getMsgTp() {
        return this.msgTp;
    }

    public void setMsgTp(String msgTp) {
        this.msgTp = msgTp;
    }

    public String getYedGlobalSerno() {
        return this.yedGlobalSerno;
    }

    public void setYedGlobalSerno(String yedGlobalSerno) {
        this.yedGlobalSerno = yedGlobalSerno;
    }

    @Override
    protected EsbReqAppHeadBean buildAppHead() {
        EsbReqAppHeadBean appHead = new EsbReqAppHeadBean();
        String instId = TraceUtil.getInstId() == null ? InstitutionEnums.InstitutionEnum.ZHYYB.getCode() : TraceUtil.getInstId();
        appHead.setInstId(instId);
        String cnlTp = TraceUtil.getCnlTp();
        appHead.setCnlTp(cnlTp);
        appHead.setUsrNo(this.usrno);
        appHead.setUsrPswd("");
        appHead.setUsrLvl("");
        appHead.setUsrTp("");
        appHead.setTlrSrlNo("");
        appHead.setCnlDtlTp("");
        appHead.setCnsmrTxnCd("");
        return appHead;
    }

    @Override
    protected EsbReqSysHeadBean buildSysHead(String serverCode, String scene) throws Exception {
        EsbReqSysHeadBean syshead = new EsbReqSysHeadBean();
        syshead.setSvcCd(serverCode);
        syshead.setScnCd(scene);
        syshead.setCnsmrSysID("2003000");
        syshead.setOrgnlCnsmrSysID("2003000");
        String consumerSrlNo = this.generateESBTradeSerialNo();
        String globalSrlNo = TraceUtil.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)this.yedGlobalSerno)) {
            syshead.setGlblSrlNo(this.yedGlobalSerno);
        } else {
            syshead.setGlblSrlNo(globalSrlNo == null ? consumerSrlNo : globalSrlNo);
        }
        syshead.setOrgnlCnsmrSysID(globalSrlNo == null ? consumerSrlNo.substring(0, 7) : globalSrlNo.substring(0, 7));
        syshead.setCnsmrSrlNo(consumerSrlNo);
        LocalDateTime date = LocalDateTime.now();
        syshead.setTxnDt(dateForm.format(date));
        syshead.setTxnTm(timeForm.format(date));
        syshead.setTxnMd(ESBClientConstance.TxnMd.ONLINE.name());
        syshead.setUsrLng(ESBClientConstance.UsrLng.CHINESE.name());
        syshead.setFileFlg(ESBClientConstance.FileFlg.NONE.VALUE);
        syshead.setEryptMd(ESBClientConstance.EryptMd.NONE.VALUE);
        syshead.setPlafmID(TraceUtil.getPlafmID());
        syshead.setPlafmUsrID(TraceUtil.getPlafmUsrID());
        syshead.setCompany("GCB");
        syshead.setOrgnlTmlIdNo("");
        syshead.setTmlIdNo("");
        syshead.setOrgnlCnsmrSvcNo("");
        syshead.setCnsmrSvcNo("");
        syshead.setMACVal("");
        syshead.setMACFctr("");
        syshead.setPINSd("");
        syshead.setSvcVerNo("");
        syshead.setVerfFlg("");
        if (StringUtils.isNotBlank((CharSequence)this.msgTp)) {
            syshead.setMsgTp(this.msgTp);
        } else {
            syshead.setMsgTp("");
        }
        syshead.setPltfmClntNo("");
        syshead.setPrdctID("");
        syshead.setRelGlblSrlNo("");
        return syshead;
    }

    private String generateESBTradeSerialNo() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("ESB", pattern);
    }
}

