/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.dxmszd;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.dxmszd.OnlineVerificationReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.MaintainEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.resp.dxmszd.OnlineVerificationResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.MaintainEcifThirdCusResp;
import com.irdstudio.efp.esb.service.client.ESBRequestBuilder;
import com.irdstudio.efp.esb.service.client.EsbBaseBean;
import com.irdstudio.efp.esb.service.facade.dxmszd.OnlineVerificationService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="onlineVerificationService")
public class OnlineVerificationServiceImpl
implements OnlineVerificationService {
    private static final Logger log = LoggerFactory.getLogger(OnlineVerificationServiceImpl.class);
    private static final String LOGGER_ID = "\u8054\u7f51\u6838\u67e5\u63a5\u53e3";

    public OnlineVerificationResp callOnlineCheck(OnlineVerificationReq onlineVerificationReq) throws Exception {
        OnlineVerificationResp resp = new OnlineVerificationResp();
        EsbRespSysHeadBean esbRespSysHeadBean = new EsbRespSysHeadBean();
        EsbRespServiceBean esbRespServiceBean = new EsbRespServiceBean();
        try {
            EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withINSTID("01328").withCNLTP("843").build();
            esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withBody(onlineVerificationReq).withTradeNo("40120001").withScene("01").create().sendAndReceive();
            esbRespSysHeadBean = esbRespServiceBean.getSysHead();
            if (MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetCd())) {
                resp = (OnlineVerificationResp)esbRespServiceBean.getBody(OnlineVerificationResp.class);
                resp.setResult(MsLoanConstant.RetCodeEnum.SUCCESS.VALUE);
                log.info("\u8054\u7f51\u6838\u67e5\u63a5\u53e3:\u8054\u7f51\u6838\u67e5\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u5f00\u59cb\u8fdb\u884c\u540e\u5904\u7406 \uff0c\u8bf7\u6c42\u53c2\u6570\uff1a " + onlineVerificationReq.toString() + ", \u8fd4\u56de\u7ed3\u679c\uff1a " + resp.toString());
            } else {
                if (((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetCd().startsWith("500")) {
                    log.info("\u8054\u7f51\u6838\u67e5\u63a5\u53e3:\u8054\u7f51\u6838\u67e5\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0cESB\u8fd4\u56de\u4fe1\u606f\uff1a" + ((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetMsg());
                    return null;
                }
                log.info("\u8054\u7f51\u6838\u67e5\u63a5\u53e3:\u8054\u7f51\u6838\u67e5\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0cESB\u8fd4\u56de\u4fe1\u606f\uff1a" + ((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetMsg());
                resp.setExmnRslt(((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetMsg());
                resp.setResult(((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetCd());
            }
            return resp;
        }
        catch (ESBException e1) {
            log.error("\u8054\u7f51\u6838\u67e5\u63a5\u53e3:\u8054\u7f51\u6838\u67e5ESB\u5f02\u5e38\uff01\u5f85\u4e0b\u6b21\u6279\u6b21\u8f6e\u8bad\u65f6\u91cd\u8bd5\uff01");
            return null;
        }
        catch (Exception e) {
            log.error("\u8054\u7f51\u6838\u67e5\u63a5\u53e3:\u8054\u7f51\u6838\u67e5\u6d88\u8d39\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaintainEcifThirdCusResp sendOnlineResultToEcif(MaintainEcifThirdCusReq maintainEcifThirdCusReq) {
        int retryTimes = 3;
        long nextRetryTime = 300L;
        while (retryTimes > 0) {
            try {
                EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withINSTID("01328").withCNLTP("843").build();
                EsbRespServiceBean esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withBody(maintainEcifThirdCusReq).withTradeNo("20120008").withScene("02").create().sendAndReceive();
                EsbRespSysHeadBean esbRespSysHeadBean = esbRespServiceBean.getSysHead();
                if (StringUtils.equals((CharSequence)((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"000000")) {
                    log.info("\u8c03\u7528ECIF\u4e09\u65b9\u5ba2\u6237\u4fe1\u606f\u7ef4\u62a4\u6210\u529f\uff01");
                    continue;
                }
                log.error("\u6210\u529f\u5224\u65ad\u4e0d\u901a\u8fc7\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + (retryTimes - 1));
                nextRetryTime = this.retry(retryTimes, nextRetryTime);
            }
            catch (Throwable throwable) {
                log.error("\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + (retryTimes - 1), throwable);
                nextRetryTime = this.retry(retryTimes, nextRetryTime);
            }
            finally {
                --retryTimes;
            }
        }
        log.info("\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + retryTimes + ", \u91cd\u8bd5\u7ed3\u675f");
        return null;
    }

    private long retry(int retryTimes, long nextRetryTime) {
        nextRetryTime *= 1L;
        if (retryTimes - 1 != 0) {
            log.info("\u4e0b\u4e00\u6b21\u91cd\u8bd5\u65f6\u95f4\uff1a" + nextRetryTime);
            this.timeWait(nextRetryTime);
        }
        return nextRetryTime;
    }

    private void timeWait(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            log.error("\u7b49\u5f85\u5931\u8d25", (Throwable)e);
        }
    }
}

