/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.esb;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.client.ESBBeanCreator;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryBaseEsbService<Q, P>
implements EsbService<Q, P> {
    private static Logger log = LoggerFactory.getLogger(AbstractRetryBaseEsbService.class);
    private static final String LOGGER_ID = "ESB\u670d\u52a1\u8c03\u7528\uff08\u5e26\u91cd\u8bd5\uff09";
    private static final ThreadLocal<String> SEQ = ThreadLocal.withInitial(() -> "\u6d41\u6c34\u53f7\uff1a");
    private static final String HEAD = "head";
    private static final String BODY = "body";

    protected void preProcess(Q reqBean) {
    }

    protected abstract String applySeq(Q var1);

    protected abstract P postProcess(Q var1, P var2) throws Exception;

    protected abstract String tradeNo();

    protected abstract String scene();

    protected abstract Function<String, P> converter();

    protected abstract ESBBeanCreator beanFactory();

    private Map<String, Object> invokeService(Q reqBean) throws Exception {
        log.info(LOGGER_ID, (Object)(SEQ.get() + "\u8c03\u7528ESB\u670d\u52a1\u5f00\u59cb\uff0c \u8bf7\u6c42\u53c2\u6570\uff1a" + reqBean));
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        this.preProcess(reqBean);
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(reqBean).withTradeNo(this.tradeNo()).withScene(this.scene()).withESBBeanFactory(this.beanFactory()).create().sendAndReceive();
            EsbRespSysHeadBean esbRespSysHeadBean = esbRespServiceBean.getSysHead();
            Object resBean = esbRespServiceBean.getBody(this.converter());
            resBean = this.postProcess(reqBean, resBean);
            retMap.put(HEAD, esbRespSysHeadBean);
            retMap.put(BODY, resBean);
            return retMap;
        }
        catch (ESBException e) {
            log.error(LOGGER_ID, (Object)(SEQ.get() + "ESB\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0cESB\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            log.error(LOGGER_ID, (Object)(SEQ.get() + "ESB\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            throw new ESBException((Throwable)e);
        }
    }

    private void timeWait(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            log.error(LOGGER_ID, (Object)(SEQ.get() + "\u7b49\u5f85\u5931\u8d25"), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public final P service(Q reqBean) throws Exception {
        if (StringUtil.isNotEmpty((String)this.applySeq(reqBean))) {
            SEQ.set(SEQ.get() + this.applySeq(reqBean) + ",");
        }
        int retryTimes = this.retryTimes();
        long nextRetryTime = this.waitTime();
        try {
            P p;
            EsbRespSysHeadBean respHead = null;
            Object res = null;
            while (retryTimes > 0) {
                try {
                    Map<String, Object> retMap = this.invokeService(reqBean);
                    res = retMap.get(BODY);
                    respHead = (EsbRespSysHeadBean)retMap.get(HEAD);
                    if (this.isSuccess(res) && this.isSuccessHead(respHead)) {
                        log.info(LOGGER_ID, (Object)(SEQ.get() + "\u8c03\u7528\u6210\u529f"));
                        Object object = res;
                        return (P)object;
                    }
                    log.error(LOGGER_ID, (Object)(SEQ.get() + "\u6210\u529f\u5224\u65ad\u4e0d\u901a\u8fc7\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + (retryTimes - 1)));
                    nextRetryTime = this.retry(retryTimes, nextRetryTime);
                }
                catch (Throwable throwable) {
                    log.error(LOGGER_ID, (Object)(SEQ.get() + "\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + (retryTimes - 1)), (Object)throwable);
                    nextRetryTime = this.retry(retryTimes, nextRetryTime);
                }
                finally {
                    --retryTimes;
                }
            }
            if (retryTimes == 0) {
                log.info(LOGGER_ID, (Object)(SEQ.get() + "\u91cd\u8bd5\u7ed3\u675f\uff0c\u91cd\u8bd5\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u56de\u8c03\u91cd\u8bd5\u540e\u5904\u7406\u65b9\u6cd5"));
                this.retryFailCallback(reqBean, respHead, res);
                p = null;
                return p;
            }
            log.info(LOGGER_ID, (Object)(SEQ.get() + "\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + retryTimes + ", \u91cd\u8bd5\u7ed3\u675f"));
            p = null;
            return p;
        }
        finally {
            SEQ.remove();
        }
    }

    private long retry(int retryTimes, long nextRetryTime) {
        nextRetryTime *= this.timeSpan().longValue();
        if (retryTimes - 1 != 0) {
            log.info(LOGGER_ID, (Object)(SEQ.get() + "\u4e0b\u4e00\u6b21\u91cd\u8bd5\u65f6\u95f4\uff1a" + nextRetryTime));
            this.timeWait(nextRetryTime);
        }
        return nextRetryTime;
    }

    protected Integer retryTimes() {
        return 3;
    }

    protected Long waitTime() {
        return 5000L;
    }

    protected Long timeSpan() {
        return 1L;
    }

    protected void retryFailCallback(Q reqBean, EsbRespSysHeadBean respHead, P res) throws Exception {
    }

    protected boolean isSuccess(P res) {
        return true;
    }

    protected boolean isSuccessHead(EsbRespSysHeadBean respHead) throws ESBException {
        if (!StringUtils.equals((CharSequence)((EsbRespRetInfBean)respHead.getRetInfArry().get(0)).getRetCd(), (CharSequence)"000000")) {
            StringBuilder errMsg = new StringBuilder("\u8c03\u7528ESB\u670d\u52a1\u5f02\u5e38");
            Optional.of(respHead).map(e -> ((EsbRespRetInfBean)e.getRetInfArry().get(0)).getRetMsg()).ifPresent(s -> errMsg.append(",\u9519\u8bef\u4fe1\u606f: ").append((String)s));
            throw new ESBException(errMsg.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Object> serviceMap(Q reqBean) throws Exception {
        if (StringUtil.isNotEmpty((String)this.applySeq(reqBean))) {
            SEQ.set(SEQ.get() + this.applySeq(reqBean) + ",");
        }
        int retryTimes = this.retryTimes();
        long nextRetryTime = this.waitTime();
        try {
            Map<String, Object> map;
            EsbRespSysHeadBean respHead = null;
            Object res = null;
            while (retryTimes > 0) {
                try {
                    Map<String, Object> retMap = this.invokeService(reqBean);
                    res = retMap.get(BODY);
                    respHead = (EsbRespSysHeadBean)retMap.get(HEAD);
                    if (this.isSuccess(res) && this.isSuccessHead(respHead)) {
                        log.info(LOGGER_ID, (Object)(SEQ.get() + "\u8c03\u7528\u6210\u529f"));
                        Map<String, Object> map2 = retMap;
                        return map2;
                    }
                    log.error(LOGGER_ID, (Object)(SEQ.get() + "\u6210\u529f\u5224\u65ad\u4e0d\u901a\u8fc7\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + (retryTimes - 1)));
                    nextRetryTime = this.retry(retryTimes, nextRetryTime);
                }
                catch (Throwable throwable) {
                    log.error(LOGGER_ID, (Object)(SEQ.get() + "\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + (retryTimes - 1)), (Object)throwable);
                    nextRetryTime = this.retry(retryTimes, nextRetryTime);
                }
                finally {
                    --retryTimes;
                }
            }
            if (retryTimes == 0) {
                log.info(LOGGER_ID, (Object)(SEQ.get() + "\u91cd\u8bd5\u7ed3\u675f\uff0c\u91cd\u8bd5\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u56de\u8c03\u91cd\u8bd5\u540e\u5904\u7406\u65b9\u6cd5"));
                this.retryFailCallback(reqBean, respHead, res);
                map = null;
                return map;
            }
            log.info(LOGGER_ID, (Object)(SEQ.get() + "\u5269\u4f59\u91cd\u8bd5\u6b21\u6570\uff1a" + retryTimes + ", \u91cd\u8bd5\u7ed3\u675f"));
            map = null;
            return map;
        }
        finally {
            SEQ.remove();
        }
    }
}

