/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.frontsystem;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.bo.req.frontsystem.TellerLoginValidationReqBean;
import com.irdstudio.efp.esb.service.bo.resp.frontsystem.TellerLoginValidationRespBean;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.facade.frontsystem.TellerLoginValidationService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tellerLoginValidationService")
public class TellerLoginValidationServiceImpl
implements TellerLoginValidationService {
    private final Logger logger = LoggerFactory.getLogger(TellerLoginValidationServiceImpl.class);
    private static final String OCM_CHANNEL_TYPE = "75";

    public TellerLoginValidationRespBean loginValidate(TellerLoginValidationReqBean tellerLoginValidationReqBean, String orgCode) throws ESBException {
        TraceUtil.setCnlTp((String)OCM_CHANNEL_TYPE);
        TraceUtil.setInstId((String)orgCode);
        TraceUtil.setUsrNo((String)tellerLoginValidationReqBean.getTlrCd());
        EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withTradeNo("50120002").withScene("03").withBody(tellerLoginValidationReqBean).create().sendAndReceive();
        TellerLoginValidationRespBean tellerLoginValidationRespBean = null;
        Optional<EsbRespSysHeadBean> sysHead = Optional.ofNullable(esbRespServiceBean.getSysHead());
        if (sysHead.isPresent()) {
            Optional esbRespRetInfBean = sysHead.get().getRetInfArry().stream().findFirst();
            if (esbRespRetInfBean.isPresent()) {
                String retCd = ((EsbRespRetInfBean)esbRespRetInfBean.get()).getRetCd();
                String retMsg = ((EsbRespRetInfBean)esbRespRetInfBean.get()).getRetMsg();
                if ("000000".equals(retCd)) {
                    String msg = "++++====>\u8c03\u7528\u5927\u524d\u7f6e\u7cfb\u7edf\u767b\u5f55\u9a8c\u8bc1\u6210\u529f<====++++";
                    this.logger.debug(msg);
                    tellerLoginValidationRespBean = (TellerLoginValidationRespBean)esbRespServiceBean.getBody(TellerLoginValidationRespBean.class);
                } else {
                    String msg = "++++====>\u8c03\u7528\u5927\u524d\u7f6e\u7cfb\u7edf\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25<====++++ " + retMsg;
                    this.logger.error(msg);
                    throw new ESBException(msg);
                }
            }
            TraceUtil.clear();
        }
        return tellerLoginValidationRespBean;
    }
}

