/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.hed;

import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.client.ESBRequestBuilder;
import com.irdstudio.efp.esb.service.client.EsbBaseBean;
import com.irdstudio.efp.esb.service.facade.hed.apply.HedLoanReleaseService;
import com.irdstudio.efp.esb.service.facade.hed.req.HedLoanReleaseReqBean;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="hedLoanReleaseService")
public class HedLoanReleaseServiceImpl
implements HedLoanReleaseService {
    private static Logger logger = LoggerFactory.getLogger(HedLoanReleaseServiceImpl.class);
    private static final String INSIT_ID = "01328";
    private static final String CNLTP = "827";

    public EsbRespServiceBean applyHjProcess(HedLoanReleaseReqBean reqBean, String global) {
        logger.info("======>\u60e0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u3010" + global + "_30210001_07\u3011\u5f00\u59cb<======");
        try {
            EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withGLBLSRLNO(global).withINSTID(INSIT_ID).withCNLTP(CNLTP).build();
            EsbRespServiceBean esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withBody(reqBean).withTradeNo("30210001").withScene("07").create().sendAndReceive();
            EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
            String retCode = "";
            if (Objects.nonNull(sysHead)) {
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                if ("000000".equals(retCode)) {
                    String msg = "\u60e0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u6210\u529f,\u4e92\u91d1\u8fd4\u56de\u7801" + retCode + ",\u5168\u5c40\u6d41\u6c34\u53f7" + global;
                    logger.info(msg);
                } else if ("SC0001".equals(retCode)) {
                    String msg = "\u60e0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u72b6\u6001\u672a\u77e5,\u4e92\u91d1\u8fd4\u56de\u7801\u4e3aSC0001\uff0c\u5168\u5c40\u6d41\u6c34\u53f7" + global;
                    logger.error(msg);
                } else if ("SC0002".equals(retCode) || "SC0003".equals(retCode) || "SC0004".equals(retCode)) {
                    String msg = "\u60e0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u5931\u8d25,\u4e92\u91d1\u8fd4\u56de\u7801" + retCode + "\uff0c\u5168\u5c40\u6d41\u6c34\u53f7" + global;
                    logger.info(msg);
                }
            }
            return esbRespServiceBean;
        }
        catch (Exception e) {
            logger.error("\u60e0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u3010_30210001_07\u3011\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

