/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.hj;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqLoanReleaseBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespLoanReleaseBean;
import com.irdstudio.efp.esb.service.client.ESBRequestBuilder;
import com.irdstudio.efp.esb.service.client.EsbBaseBean;
import com.irdstudio.efp.esb.service.facade.hj.LoanReleaseService;
import com.irdstudio.efp.nls.common.exception.LoanReleaseException;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="loanReleaseService")
public class LoanReleaseServiceImpl
implements LoanReleaseService {
    private Logger logger = LoggerFactory.getLogger(LoanReleaseServiceImpl.class);
    private final String msgTemplate = "message{ }";
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RespLoanReleaseBean loanRelease(ReqLoanReleaseBean reqLoanReleaseBean, String applySeq) throws LoanReleaseException {
        this.logger.info("======>\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "_30210001_01\u3011\u5f00\u59cb<======");
        NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
        nlsApplyInfoVO.setApplySeq(applySeq);
        nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
        RespLoanReleaseBean respLoanReleaseBean = null;
        String retCode = "";
        if (nlsApplyInfoVO != null) {
            EsbRespServiceBean esbRespServiceBean = null;
            try {
                EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withGLBLSRLNO(nlsApplyInfoVO.getGlobalSerno()).withINSTID("00043").withPLAFMUSRID(nlsApplyInfoVO.getPlatfmUsrID()).withPLATFMID(nlsApplyInfoVO.getPlatfmId()).build();
                esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withBody(reqLoanReleaseBean).withTradeNo("30210001").withScene("01").create().sendAndReceive();
            }
            catch (ESBException e) {
                e.printStackTrace();
                throw new LoanReleaseException("\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\u3010" + applySeq + "_30220001_11\u3011" + (Object)((Object)e));
            }
            EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
            if (Objects.nonNull(sysHead)) {
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                if (!"000000".equals(retCode)) {
                    String msg3 = esbRespRetInfBean.getRetMsg();
                    this.logger.error(msg3);
                    throw new LoanReleaseException(msg3);
                }
                String msg2 = "++++====>\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u6210\u529f<====++++";
                respLoanReleaseBean = (RespLoanReleaseBean)esbRespServiceBean.getBody(RespLoanReleaseBean.class);
                this.logger.debug(msg2, (Object)"message{ }");
            }
        } else {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "_30220001_11\u3011 \u83b7\u53d6\u7684\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\u7a7a");
            }
            throw new LoanReleaseException("\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "_30220001_11\u3011 \u83b7\u53d6\u7684\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        this.logger.info("======>\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "_30210001_01\u3011\u7ed3\u675f<======");
        return respLoanReleaseBean;
    }
}

