/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.psd;

import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.bo.req.psd.PsdLoanReleaseReqBean;
import com.irdstudio.efp.esb.service.bo.resp.psd.PsdLoanReleaseRespBean;
import com.irdstudio.efp.esb.service.client.ESBRequestBuilder;
import com.irdstudio.efp.esb.service.client.EsbBaseBean;
import com.irdstudio.efp.esb.service.facade.psd.PsdLoanReleaseService;
import com.irdstudio.efp.nls.common.exception.LoanReleaseException;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdHjLoanReleaseService")
public class PsdLoanReleaseServiceImpl
implements PsdLoanReleaseService {
    private static Logger logger = LoggerFactory.getLogger(PsdLoanReleaseServiceImpl.class);
    private final String msgTemplate = "message{ }";
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;

    public PsdLoanReleaseRespBean applyPsdLoanRelease(PsdLoanReleaseReqBean psdLoanReleaseReqBean, NlsApplyInfoVO nlsApplyInfo) throws LoanReleaseException {
        String applySeq = nlsApplyInfo.getApplySeq();
        logger.info("======>\u666e\u7a0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u3010" + applySeq + "_30210001_04\u3011\u5f00\u59cb<======");
        NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
        nlsApplyInfoVO.setApplySeq(applySeq);
        nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
        PsdLoanReleaseRespBean psdLoanReleaseRespBean = null;
        EsbRespServiceBean recvBean = null;
        try {
            EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withGLBLSRLNO(nlsApplyInfoVO.getGlobalSerno()).withINSTID("00043").withPLAFMUSRID(nlsApplyInfoVO.getPlatfmUsrID()).withPLATFMID(nlsApplyInfoVO.getPlatfmId()).withCNLTP(nlsApplyInfo.getCnlTp()).build();
            recvBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withBody(psdLoanReleaseReqBean).withTradeNo("30210001").withScene("04").create().sendAndReceive();
        }
        catch (Exception e) {
            logger.error("\u666e\u7a0e\u8d37\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u63a5\u53e3\u301030210001_04\u3011\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            throw new LoanReleaseException("\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\u3010" + applySeq + "_30210001_04\u3011" + e);
        }
        EsbRespSysHeadBean sysHead = recvBean.getSysHead();
        if (Objects.nonNull(sysHead)) {
            EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
            String retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
            if (!"000000".equals(retCode)) {
                String msg3 = esbRespRetInfBean.getRetMsg();
                logger.error(msg3);
                throw new LoanReleaseException(msg3);
            }
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "_30210001_04\u3011 \u83b7\u53d6\u7684\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\u7a7a");
            }
            throw new LoanReleaseException("\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "__30210001_04\u3011 \u83b7\u53d6\u7684\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        String msg2 = "++++====>\u8bf7\u6c42\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u6210\u529f<====++++";
        psdLoanReleaseRespBean = (PsdLoanReleaseRespBean)recvBean.getBody(PsdLoanReleaseRespBean.class);
        logger.debug(msg2, (Object)"message{ }");
        logger.info("======>\u8c03\u7528\u8d37\u6b3e\u5f00\u7acb\u53d1\u670d\u52a1\u63a5\u53e3\u3010" + applySeq + "_30210001_04\u3011\u7ed3\u675f<======");
        return psdLoanReleaseRespBean;
    }
}

