/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.sed.cfca;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.Base64;
import com.irdstudio.basic.framework.core.util.FileUtil;
import com.irdstudio.basic.framework.core.util.UUIDUtil;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.service.bo.req.dzqz.ReqElectronicSignature3203Bean;
import com.irdstudio.efp.esb.service.bo.req.dzqz.ReqElectronicSignatureDL01Bean;
import com.irdstudio.efp.esb.service.bo.req.sed.cfca.ReqElectronicSignature3207Bean;
import com.irdstudio.efp.esb.service.bo.req.sed.cfca.ReqSedCfcaOpenAccountBean;
import com.irdstudio.efp.esb.service.bo.resp.dzqz.RspElectronicSignature3203Bean;
import com.irdstudio.efp.esb.service.bo.resp.dzqz.RspElectronicSignatureDL01Bean;
import com.irdstudio.efp.esb.service.bo.resp.sed.cfca.RespElectronicSignature3207Bean;
import com.irdstudio.efp.esb.service.bo.resp.sed.cfca.RespSedCfcaOpenAccountBean;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.facade.sed.cfca.SedCfcaService;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sedCfcaService")
public class SedCfcaServiceImpl
implements SedCfcaService {
    private static Logger logger = LoggerFactory.getLogger(SedCfcaServiceImpl.class);
    @Value(value="${contract.sxModelFilePath}")
    private String contractSxModelFilePath;
    @Value(value="${contract.dkModelFilePath}")
    private String contractDkModelFilePath;
    @Value(value="${contract.tmpFilePath}")
    private String contractTmpFilePath;
    private static final List<String> contractList = new ArrayList<String>();

    public RespSedCfcaOpenAccountBean openAccount(ReqSedCfcaOpenAccountBean req) throws ESBException {
        logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e2a\u4eba\u5f00\u6237\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)req));
        RespSedCfcaOpenAccountBean rspBean = new RespSedCfcaOpenAccountBean();
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(req).withTradeNo("20120001").withScene("04").create().sendAndReceive();
            Optional.ofNullable(esbRespServiceBean.getSysHead()).orElseThrow(() -> new ESBException("\u8bbf\u95eeESB\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\u6216ESB\u662f\u5426\u8fde\u901a"));
            List retInfArry = esbRespServiceBean.getSysHead().getRetInfArry();
            Optional.ofNullable(retInfArry).orElseThrow(() -> new ESBException("\u5f00\u653e\u5e73\u53f0\u8fd4\u56de\u7684\u5904\u7406\u4fe1\u606f\u6570\u7ec4RetInfArry\u4e3a\u7a7a"));
            if (!"000000".equals(((EsbRespRetInfBean)retInfArry.get(0)).getRetCd())) {
                throw new ESBException("\u5f00\u653e\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a" + retInfArry.toString());
            }
            rspBean = (RespSedCfcaOpenAccountBean)esbRespServiceBean.getBody(RespSedCfcaOpenAccountBean.class);
            logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e2a\u4eba\u5f00\u6237\u7ed3\u675f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)rspBean));
        }
        catch (ESBException e) {
            e.printStackTrace();
            logger.error("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e2a\u4eba\u5f00\u6237\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ESBException("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e2a\u4eba\u5f00\u6237\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBean;
    }

    public RspElectronicSignature3203Bean signContract(ReqElectronicSignature3203Bean req3203Bean) throws ESBException {
        logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e0a\u4f20\u5408\u540c\u7b7e\u7f72\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)req3203Bean));
        RspElectronicSignature3203Bean rspBean = new RspElectronicSignature3203Bean();
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(req3203Bean).withTradeNo("30220008").withScene("01").create().sendAndReceive();
            Optional.ofNullable(esbRespServiceBean.getSysHead()).orElseThrow(() -> new ESBException("\u8bbf\u95eeESB\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\u6216ESB\u662f\u5426\u8fde\u901a"));
            List retInfArry = esbRespServiceBean.getSysHead().getRetInfArry();
            Optional.ofNullable(retInfArry).orElseThrow(() -> new ESBException("\u5f00\u653e\u5e73\u53f0\u8fd4\u56de\u7684\u5904\u7406\u4fe1\u606f\u6570\u7ec4RetInfArry\u4e3a\u7a7a"));
            if (!"000000".equals(((EsbRespRetInfBean)retInfArry.get(0)).getRetCd())) {
                throw new ESBException("\u5f00\u653e\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a" + retInfArry.toString());
            }
            rspBean = (RspElectronicSignature3203Bean)esbRespServiceBean.getBody(RspElectronicSignature3203Bean.class);
            logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\uff1a\u4e0a\u4f20\u5408\u540c\u7b7e\u7f72\u7ed3\u675f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)rspBean));
        }
        catch (ESBException e) {
            logger.error("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e0a\u4f20\u5408\u540c\u7b7e\u7f72\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ESBException("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e0a\u4f20\u5408\u540c\u7b7e\u7f72\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e0a\u4f20\u5408\u540c\u7b7e\u7f72\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ESBException("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u4e0a\u4f20\u5408\u540c\u7b7e\u7f72\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBean;
    }

    public RespElectronicSignature3207Bean signSeal(ReqElectronicSignature3207Bean req3207Bean) throws ESBException {
        logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5173\u952e\u5b57\u7b7e\u7f72\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)req3207Bean));
        RespElectronicSignature3207Bean resp3207Bean = new RespElectronicSignature3207Bean();
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(req3207Bean).withTradeNo("30220008").withScene("04").create().sendAndReceive();
            Optional.ofNullable(esbRespServiceBean.getSysHead()).orElseThrow(() -> new ESBException("\u8bbf\u95eeESB\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\u6216ESB\u662f\u5426\u8fde\u901a"));
            List retInfArry = esbRespServiceBean.getSysHead().getRetInfArry();
            Optional.ofNullable(retInfArry).orElseThrow(() -> new ESBException("\u5f00\u653e\u5e73\u53f0\u8fd4\u56de\u7684\u5904\u7406\u4fe1\u606f\u6570\u7ec4RetInfArry\u4e3a\u7a7a"));
            if (!"000000".equals(((EsbRespRetInfBean)retInfArry.get(0)).getRetCd())) {
                throw new ESBException("\u5f00\u653e\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a" + retInfArry.toString());
            }
            resp3207Bean = (RespElectronicSignature3207Bean)esbRespServiceBean.getBody(RespElectronicSignature3207Bean.class);
            logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5173\u952e\u5b57\u7b7e\u7f72\u7ed3\u675f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)resp3207Bean));
        }
        catch (ESBException e) {
            logger.error("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5173\u952e\u5b57\u7b7e\u7f72\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ESBException("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5173\u952e\u5b57\u7b7e\u7f72\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return resp3207Bean;
    }

    public RspElectronicSignatureDL01Bean downloadContract(ReqElectronicSignatureDL01Bean reqCADL01Bean) throws ESBException {
        logger.debug("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\uff1a\u5408\u540c\u4e0b\u8f7d\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)reqCADL01Bean));
        RspElectronicSignatureDL01Bean rspBean = new RspElectronicSignatureDL01Bean();
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(reqCADL01Bean).withTradeNo("30220003").withScene("02").create().sendAndReceive();
            Optional.ofNullable(esbRespServiceBean.getSysHead()).orElseThrow(() -> new ESBException("\u8bbf\u95eeESB\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\u6216ESB\u662f\u5426\u8fde\u901a"));
            List retInfArry = esbRespServiceBean.getSysHead().getRetInfArry();
            Optional.ofNullable(retInfArry).orElseThrow(() -> new ESBException("\u5f00\u653e\u5e73\u53f0\u8fd4\u56de\u7684\u5904\u7406\u4fe1\u606f\u6570\u7ec4RetInfArry\u4e3a\u7a7a"));
            if (!"000000".equals(((EsbRespRetInfBean)retInfArry.get(0)).getRetCd())) {
                throw new ESBException("\u5f00\u653e\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a" + retInfArry.toString());
            }
            rspBean = (RspElectronicSignatureDL01Bean)esbRespServiceBean.getBody(RspElectronicSignatureDL01Bean.class);
            logger.info("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\uff1a\u5408\u540c\u4e0b\u8f7d\u7ed3\u675f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)rspBean));
        }
        catch (ESBException e) {
            logger.error("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ESBException("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ESBException("\u7535\u5b50\u7b7e\u7ae0\u5904\u7406\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBean;
    }

    public String createLocalContract(String contractType, Map<String, String> contractMap) throws Exception {
        logger.info("\u6b63\u5728\u8bfb\u53d6\u672c\u5730\u5408\u540c\u6a21\u677f\u6587\u4ef6");
        PdfReader pdfReader = null;
        FileOutputStream out = null;
        PdfStamper pdfStamper = null;
        try {
            if ("01".equals(contractType)) {
                pdfReader = new PdfReader(this.contractSxModelFilePath);
            } else if ("02".equals(contractType)) {
                pdfReader = new PdfReader(this.contractDkModelFilePath);
            }
            File outFile = new File(this.contractTmpFilePath);
            out = new FileOutputStream(outFile);
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)out);
            BaseFont baseFont = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            AcroFields fields = pdfStamper.getAcroFields();
            pdfStamper.setFormFlattening(true);
            if (contractMap == null) {
                throw new BizException("\u5408\u540c\u5b57\u6bb5\u6620\u5c04contractMap\u4e0d\u80fd\u4e3a\u7a7a");
            }
            logger.info("\u5f00\u59cb\u5728\u672c\u5730\u751f\u6210\u5408\u540c\u6587\u4ef6\uff0c\u4e34\u65f6\u5408\u540c\u6587\u4ef6\u5730\u5740\u4e3a\uff1a" + this.contractTmpFilePath);
            for (String key : contractMap.keySet()) {
                fields.setFieldProperty(key, "textFont", (Object)baseFont, null);
                fields.setField(key, contractMap.get(key));
            }
            if (pdfStamper != null) {
                pdfStamper.close();
            }
            if (out != null) {
                out.close();
            }
            if (pdfReader != null) {
                pdfReader.close();
            }
            outFile = new File(this.contractTmpFilePath);
            String string = Base64.encodeBytes((byte[])FileUtil.toByteArray((File)outFile));
            return string;
        }
        catch (BizException e) {
            throw new BizException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8bf7\u68c0\u67e5\u5408\u540c\u6a21\u677f\u662f\u5426\u5728\u914d\u7f6e\u7684\u8def\u5f84\u4e0b");
        }
        finally {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
            if (out != null) {
                out.close();
            }
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    public String fillPdfContent(String contractType, Map<String, String> contractMap) throws Exception {
        String pdfFilePath = null;
        if ("01".equals(contractType)) {
            pdfFilePath = this.contractSxModelFilePath;
        } else if ("02".equals(contractType)) {
            pdfFilePath = this.contractDkModelFilePath;
        }
        if (StringUtils.isEmpty((CharSequence)pdfFilePath)) {
            throw new Exception("\u975e\u6cd5\u7684\u5408\u540c\u7c7b\u578b");
        }
        if (!new File(pdfFilePath).exists()) {
            throw new Exception("\u6839\u636epdf\u8def\u5f84\u83b7\u53d6\u5230\u7684\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (contractMap == null || contractMap.size() < 1) {
            throw new Exception("\u586b\u5145\u5185\u5bb9\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        logger.info("\u586b\u5145\u6a21\u677f\u5185\u5bb9\u5f00\u59cb\uff1a");
        PdfReader pdfReader = null;
        FileOutputStream out = null;
        PdfStamper pdfStamper = null;
        File tmpFile = null;
        try {
            pdfReader = new PdfReader(pdfFilePath);
            String tmpFileName = FilenameUtils.getFullPath((String)pdfFilePath) + UUIDUtil.getUUID() + ".pdf";
            out = new FileOutputStream(tmpFileName);
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)out);
            BaseFont baseFont = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            AcroFields fields = pdfStamper.getAcroFields();
            pdfStamper.setFormFlattening(true);
            contractMap.forEach((k, v) -> {
                fields.setFieldProperty(k, "textFont", (Object)baseFont, null);
                try {
                    fields.setField(k, v);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u586b\u5145\u5185\u5bb9\u62a5\u9519", (Throwable)e);
                }
            });
            pdfStamper.flush();
            if (pdfStamper != null) {
                pdfStamper.close();
            }
            if (out != null) {
                out.close();
            }
            if (pdfReader != null) {
                pdfReader.close();
            }
            if (!(tmpFile = new File(tmpFileName)).exists()) {
                throw new RuntimeException("\u83b7\u53d6\u4e34\u65f6\u6587\u4ef6\u51fa\u9519");
            }
            String rtBase64Str = Base64.encodeBytes((byte[])FileUtil.toByteArray((File)tmpFile));
            if (StringUtils.isEmpty((CharSequence)rtBase64Str)) {
                throw new RuntimeException("\u586b\u5145\u6a21\u677f\u6587\u4ef6\u51fa\u9519\uff0c\u751f\u6210\u7684\u6587\u4ef6\u4e3a\u7a7a");
            }
            String string = rtBase64Str;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8bf7\u68c0\u67e5\u5408\u540c\u6a21\u677f\u662f\u5426\u5728\u914d\u7f6e\u7684\u8def\u5f84\u4e0b");
        }
        finally {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
            if (out != null) {
                out.close();
            }
            if (pdfReader != null) {
                pdfReader.close();
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    static {
        contractList.add("lmtContNo");
        contractList.add("orgName");
        contractList.add("orgAddr");
        contractList.add("orgZipcode");
        contractList.add("orgTel");
        contractList.add("cusName");
        contractList.add("certType");
        contractList.add("certCode");
        contractList.add("cusAddr");
        contractList.add("cusZipcode");
        contractList.add("cusPhone");
        contractList.add("cusTax");
        contractList.add("cusEmail");
        contractList.add("signDate");
        contractList.add("certCode2");
        contractList.add("lmtAmtUpper");
        contractList.add("lmtAmtLower");
        contractList.add("validMonth");
        contractList.add("lmtStartYear");
        contractList.add("lmtStartMonth");
        contractList.add("lmtStartDay");
        contractList.add("lmtEndYear");
        contractList.add("lmtEndMonth");
        contractList.add("lmtEndDay");
        contractList.add("contNo");
        contractList.add("distAccName");
        contractList.add("distAccountNo");
        contractList.add("repayAccountNo");
        contractList.add("repayAccName");
        contractList.add("loanAmtUpper");
        contractList.add("loanAmtLower");
        contractList.add("loanTermType");
        contractList.add("loanTermTypeY");
        contractList.add("loanTermTypeM");
        contractList.add("loanTermTypeO");
        contractList.add("finRateType");
        contractList.add("finUp");
        contractList.add("finDown");
        contractList.add("repayMode");
        contractList.add("repayDay1");
        contractList.add("repayDay2");
        contractList.add("repayDay3");
    }
}

