/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.sx;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.req.sx.HedCreditRiskApproveReq;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.sx.HedCreditRiskApproveResp;
import com.irdstudio.efp.esb.service.client.ESBBeanCreator;
import com.irdstudio.efp.esb.service.client.impl.HEDESBBeanCreator;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.esb.service.impl.esb.AbstractRetryBaseEsbService;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="hedCreditRiskInvokService")
public class HedCreditRiskInvokServiceImpl
extends AbstractRetryBaseEsbService<HedCreditRiskApproveReq, HedCreditRiskApproveResp> {
    private static Logger logger = LoggerFactory.getLogger(HedCreditRiskInvokServiceImpl.class);
    private static final String LOGGER_ID = "\u60e0e\u8d37\u6388\u4fe1\u9636\u6bb5\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3";
    private String globalSerno;
    private String InstId;
    private String CnlTp;
    private String PlafmID;
    private String PlafmUsrID;
    @Autowired
    @Qualifier(value="alarmJudgementService")
    private AlarmJudgementService alarmJudgementService;

    public String getGlobalSerno() {
        return this.globalSerno;
    }

    public void setGlobalSerno(String globalSerno) {
        this.globalSerno = globalSerno;
    }

    public String getInstId() {
        return this.InstId;
    }

    public void setInstId(String instId) {
        this.InstId = instId;
    }

    public String getCnlTp() {
        return this.CnlTp;
    }

    public void setCnlTp(String cnlTp) {
        this.CnlTp = cnlTp;
    }

    public String getPlafmID() {
        return this.PlafmID;
    }

    public void setPlafmID(String plafmID) {
        this.PlafmID = plafmID;
    }

    public String getPlafmUsrID() {
        return this.PlafmUsrID;
    }

    public void setPlafmUsrID(String plafmUsrID) {
        this.PlafmUsrID = plafmUsrID;
    }

    @Override
    protected String applySeq(HedCreditRiskApproveReq reqBean) {
        if (reqBean != null) {
            return reqBean.getAppNo();
        }
        return "";
    }

    @Override
    protected ESBBeanCreator beanFactory() {
        HEDESBBeanCreator hedesbBeanCreator = (HEDESBBeanCreator)SpringContextUtils.getBean((String)"HEDESBBeanCreator");
        hedesbBeanCreator.setGlblSrlNo(this.globalSerno);
        hedesbBeanCreator.setInstId(this.InstId);
        hedesbBeanCreator.setCnlTp(this.CnlTp);
        hedesbBeanCreator.setPlafmID(this.PlafmID);
        hedesbBeanCreator.setPlafmUsrID(this.PlafmUsrID);
        return hedesbBeanCreator;
    }

    @Override
    protected HedCreditRiskApproveResp postProcess(HedCreditRiskApproveReq reqBean, HedCreditRiskApproveResp resBean) throws Exception {
        Optional.ofNullable(resBean).map(i -> i.getRcvSt()).orElseThrow(() -> new ESBException("\u60e0e\u8d37\u6388\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01"));
        logger.debug(LOGGER_ID, (Object)("\u60e0e\u8d37\u6388\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8fdb\u884c\u540e\u7eed\u5904\u7406\uff0c\u8bf7\u6c42\u53c2\u6570: " + reqBean + ", \u8fd4\u56de\u7ed3\u679c\uff1a " + resBean));
        return resBean;
    }

    @Override
    protected String tradeNo() {
        return "30220006";
    }

    @Override
    protected String scene() {
        return "21";
    }

    @Override
    protected Integer retryTimes() {
        return 4;
    }

    @Override
    protected Long waitTime() {
        return 120000L;
    }

    @Override
    protected Long timeSpan() {
        return 1L;
    }

    @Override
    protected void retryFailCallback(HedCreditRiskApproveReq reqBean, EsbRespSysHeadBean respHead, HedCreditRiskApproveResp res) throws Exception {
        ReqAlarmJudgementBean reqAlarmJudgementBean = new ReqAlarmJudgementBean();
        reqAlarmJudgementBean.setAlrmInf("\u60e0e\u8d37\u6388\u4fe1\u9636\u6bb5\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8c03\u75283\u6b21\u5931\u8d25\uff01\u6d41\u6c34\u53f7\uff1a" + reqBean.getAppNo());
        this.getrespAlarmJudgementBean(reqAlarmJudgementBean);
        logger.error(LOGGER_ID, (Object)("\u60e0e\u8d37\u6388\u4fe1\u9636\u6bb5\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8c03\u7528\u91cd\u8bd5\u5931\u8d25\uff01\u6d41\u6c34\u53f7\uff1a" + reqBean.getAppNo()));
        throw new ESBException("\u60e0e\u8d37\u6388\u4fe1\u9636\u6bb5\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8c03\u75283\u6b21\u5931\u8d25");
    }

    @Override
    protected boolean isSuccess(HedCreditRiskApproveResp res) {
        return MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(res.getRcvSt());
    }

    @Override
    protected Function<String, HedCreditRiskApproveResp> converter() {
        return i -> (HedCreditRiskApproveResp)JSONObject.parseObject((String)i, (TypeReference)new TypeReference<HedCreditRiskApproveResp>(){}, (Feature[])new Feature[0]);
    }

    public RespAlarmJudgementBean getrespAlarmJudgementBean(ReqAlarmJudgementBean reqAlarmJudgementBean) throws Exception {
        RespAlarmJudgementBean respAlarmJudgementBean = null;
        try {
            reqAlarmJudgementBean.setMonObjNm("\u60e0e\u8d37");
            reqAlarmJudgementBean.setMonObjSpfTpVal("\u5916\u90e8\u63a5\u53e3");
            reqAlarmJudgementBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmTmstmp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            reqAlarmJudgementBean.setMonAlrmLvl("3");
            respAlarmJudgementBean = this.alarmJudgementService.alarmJudgement(reqAlarmJudgementBean);
            logger.debug("\u8c03\u7528\u544a\u8b66\u5224\u65ad\u8fd4\u56de\u7801\uff1a\u3010" + respAlarmJudgementBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + respAlarmJudgementBean.getRetMsg() + "\u3011");
        }
        catch (Exception e) {
            logger.info("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
        return respAlarmJudgementBean;
    }

    @Override
    protected void preProcess(HedCreditRiskApproveReq reqBean) {
        this.setGlobalSerno(reqBean.getGlblSrlNo());
        this.setInstId(reqBean.getInstId());
        this.setCnlTp(reqBean.getCnlTp());
        this.setPlafmID(reqBean.getPlafmID());
        this.setPlafmUsrID(reqBean.getPlafmUsrID());
    }
}

