/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.yed;

import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedCompanyInfoRequestBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedGjjAccInfoReqBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedGjjCompnayInfoRequestBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedNJGjjAccNoInfoReq;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedCompanyInfoReqBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedGjjAccNoInfoResponseBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedGjjCompanyInfoResponseBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedNJGjjAccNoInfoResp;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.client.ESBRequestBuilder;
import com.irdstudio.efp.esb.service.client.EsbBaseBean;
import com.irdstudio.efp.esb.service.client.impl.YEDESBBeanCreator;
import com.irdstudio.efp.esb.service.facade.yed.YedCompanyInfoService;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="yedCompanyInfoService")
public class YedCompanyInfoServiceImpl
implements YedCompanyInfoService {
    private final Logger log = LoggerFactory.getLogger(YedCompanyInfoServiceImpl.class);
    @Value(value="${esb.client.yed.usrno}")
    private String usrno;
    private static final String QryTpId = "25123";
    private static final String ChrgSbrprtTpIdGrp = "21301";
    private static final String QryRsnId = "101";
    public static final String TRADE_NO_20120005 = "20120005";
    public static final String YED_GJJ_02 = "02";
    public static final String TRADE_NO_30730002 = "30730002";
    public static final String YED_GJJ_03 = "03";
    public static final String TRADE_NO_40130013 = "40130013";
    public static final String YED_PY_01 = "01";
    public static final String TRADE_NO_30230003 = "30230003";
    public static final String YED_GJJ_28 = "28";

    @DisconfItem(key="esb.client.yed.usrno", associateField="usrno")
    public String getUsrno() {
        return this.usrno;
    }

    public void setUsrno(String usrno) {
        this.usrno = usrno;
    }

    public YedCompanyInfoReqBean queryCompanyInfoForIOP(YedCompanyInfoRequestBean requestBean) throws Exception {
        YedCompanyInfoReqBean yedCompanyInfoReqBean;
        block4: {
            if (StringUtils.isBlank((CharSequence)requestBean.getEntpNm())) {
                this.log.info("\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
            }
            yedCompanyInfoReqBean = null;
            requestBean.setQryTpId(QryTpId);
            requestBean.setChrgSbrprtTpIdGrp(ChrgSbrprtTpIdGrp);
            requestBean.setQryRsnId(QryRsnId);
            EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withUSRNO("98135").withCNLTP("843").withGLBLSRLNO(requestBean.getGlobalSerno()).build();
            EsbRespServiceBean esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withTradeNo(TRADE_NO_40130013).withScene(YED_PY_01).withBody(requestBean).create().sendAndReceive();
            String retCode = "";
            try {
                EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
                if (!Objects.nonNull(sysHead)) break block4;
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                if ("000000".equals(retCode)) {
                    String msg = "\u8c03\u7528\u9e4f\u5143\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u6210\u529f";
                    this.log.debug(msg);
                    yedCompanyInfoReqBean = (YedCompanyInfoReqBean)esbRespServiceBean.getBody(YedCompanyInfoReqBean.class);
                    break block4;
                }
                String msg = "\u8c03\u7528\u9e4f\u5143\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25 " + esbRespRetInfBean.getRetMsg();
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
            catch (Exception e) {
                String msg = "\u8c03\u7528\u9e4f\u5143\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38";
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
        }
        return yedCompanyInfoReqBean;
    }

    public YedGjjCompanyInfoResponseBean queryGJJCompanyInfoForEDS(YedGjjCompnayInfoRequestBean requestBean) throws Exception {
        YedGjjCompanyInfoResponseBean responseBean;
        block4: {
            if (StringUtils.isBlank((CharSequence)requestBean.getIdentNo()) || StringUtils.isBlank((CharSequence)requestBean.getIdentTp()) || StringUtils.isBlank((CharSequence)requestBean.getBeQryPrsnNm())) {
                this.log.info("\u8bc1\u4ef6\u7c7b\u578b\uff0c\u6216\u8005\u8bc1\u4ef6\u53f7\u7801\uff0c\u6216\u8005\u59d3\u540d\u4e3a\u7a7a!\u8bc1\u4ef6\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a{}\uff0c\u59d3\u540d\u4e3a\uff1a{}", new Object[]{requestBean.getIdentTp(), requestBean.getIdentNo(), requestBean.getBeQryPrsnNm()});
            }
            responseBean = null;
            requestBean.setBnkNo("21");
            requestBean.setCnterNo("\u7528\u4fe1");
            requestBean.setDeptNo("4001000");
            requestBean.setIntfTxnCd("DS10");
            requestBean.setPlatFlowNo("");
            requestBean.setSvcNo("\u4f18e\u8d37");
            requestBean.setSysNo("4001000");
            requestBean.setTxnCd("DS10");
            requestBean.setTxnSrlNo("DS100120171011000001");
            EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withUSRNO(this.usrno).withCNLTP("843").withGLBLSRLNO(requestBean.getGlobalSerno()).withMSGTP("Request").build();
            EsbRespServiceBean esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withTradeNo(TRADE_NO_20120005).withScene(YED_GJJ_02).withBody(requestBean).create().sendAndReceive();
            String retCode = "";
            try {
                EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
                if (!Objects.nonNull(sysHead)) break block4;
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                if ("000000".equals(retCode)) {
                    String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u6210\u529f";
                    this.log.debug(msg);
                    responseBean = (YedGjjCompanyInfoResponseBean)esbRespServiceBean.getBody(YedGjjCompanyInfoResponseBean.class);
                    break block4;
                }
                String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u5931\u8d25 " + esbRespRetInfBean.getRetMsg();
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
            catch (Exception e) {
                String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u5f02\u5e38";
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
        }
        return responseBean;
    }

    public YedGjjAccNoInfoResponseBean queryGJJAccNOInfoForEDS(YedGjjAccInfoReqBean requestBean) throws Exception {
        YedGjjAccNoInfoResponseBean responseBean;
        block4: {
            if (StringUtils.isBlank((CharSequence)requestBean.getPrvdntAcctNo())) {
                this.log.info("\u516c\u79ef\u91d1\u8d26\u53f7\u4e3a\u7a7a\uff01\u516c\u79ef\u91d1\u8d26\u53f7\u4e3a\uff1a{}", (Object)requestBean.getPrvdntAcctNo());
            }
            responseBean = null;
            requestBean.setBnkNo("21");
            requestBean.setCnterNo("\u6388\u4fe1");
            requestBean.setDeptNo("4001000");
            requestBean.setIntfTxnCd("DS21");
            requestBean.setPlatFlowNo("");
            requestBean.setSvcNo("\u4f18e\u8d37");
            requestBean.setSysNo("4001000");
            requestBean.setTxnCd("DS21");
            requestBean.setTxnSrlNo("DS210120171011000001");
            EsbBaseBean esbBaseBean = EsbBaseBean.EsbBaseBeanBuilder.anEsbBaseBean().withUSRNO(this.usrno).withCNLTP("843").withGLBLSRLNO(requestBean.getGlobalSerno()).build();
            EsbRespServiceBean esbRespServiceBean = ESBRequestBuilder.buildClient().withEsbBaseBean(esbBaseBean).withTradeNo(TRADE_NO_30730002).withScene(YED_GJJ_03).withBody(requestBean).create().sendAndReceive();
            String retCode = "";
            try {
                EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
                if (!Objects.nonNull(sysHead)) break block4;
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                if ("000000".equals(retCode)) {
                    String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u6210\u529f";
                    this.log.debug(msg);
                    responseBean = (YedGjjAccNoInfoResponseBean)esbRespServiceBean.getBody(YedGjjAccNoInfoResponseBean.class);
                    break block4;
                }
                String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u5931\u8d25 " + esbRespRetInfBean.getRetMsg();
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
            catch (Exception e) {
                String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u5f02\u5e38 ";
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
        }
        return responseBean;
    }

    public YedNJGjjAccNoInfoResp queryNjGjjAccNoINfoForEDS(YedNJGjjAccNoInfoReq requestBean) throws Exception {
        YedNJGjjAccNoInfoResp responseBean;
        block4: {
            responseBean = null;
            if (StringUtils.isBlank((CharSequence)requestBean.getIdentNo()) || StringUtils.isBlank((CharSequence)requestBean.getNm()) || StringUtils.isBlank((CharSequence)requestBean.getCtcTelNo()) || StringUtils.isBlank((CharSequence)requestBean.getCstdyFlg())) {
                this.log.info("\u5fc5\u8f93\u5b57\u6bb5\u4e3a\u7a7a");
                return responseBean;
            }
            requestBean.setCnterNo("\u6388\u4fe1");
            requestBean.setDeptNo("00043");
            requestBean.setIntfTxnCd("2013000546");
            requestBean.setSvcNo("\u4f18e\u8d37");
            requestBean.setSysNo("2003000");
            YEDESBBeanCreator yedesbBeanCreator = (YEDESBBeanCreator)SpringContextUtils.getBean((String)"YEDESBBeanCreator");
            yedesbBeanCreator.setMsgTp("Request");
            yedesbBeanCreator.setYedGlobalSerno(requestBean.getGlobalSerno());
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withTradeNo(TRADE_NO_30230003).withScene(YED_GJJ_28).withBody(requestBean).withESBBeanFactory(yedesbBeanCreator).create().sendAndReceive();
            String retCode = "";
            try {
                EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
                if (!Objects.nonNull(sysHead)) break block4;
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                if ("000000".equals(retCode)) {
                    String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u5357\u4eac\u516c\u79ef\u91d1\u8d26\u53f7\u6210\u529f";
                    this.log.debug(msg);
                    responseBean = (YedNJGjjAccNoInfoResp)esbRespServiceBean.getBody(YedNJGjjAccNoInfoResp.class);
                    break block4;
                }
                String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u5357\u4eac\u516c\u79ef\u91d1\u8d26\u53f7\u5931\u8d25 " + esbRespRetInfBean.getRetMsg();
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
            catch (Exception e) {
                String msg = "\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u5f02\u5e38";
                this.log.error(msg);
                throw new ESBException(EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), msg);
            }
        }
        return responseBean;
    }
}

