/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.zx;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.efp.esb.common.constant.ZXReturnType;
import com.irdstudio.efp.esb.service.bo.req.BaseZXReqBean;
import com.irdstudio.efp.esb.service.bo.req.ZX10001QueryReports;
import com.irdstudio.efp.esb.service.bo.resp.zx.BaseZXResBean;
import com.irdstudio.efp.esb.service.bo.resp.zx.ZX10001HTMLResponseReport;
import com.irdstudio.efp.esb.service.impl.zx.BaseZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service(value="zx10001HTMLService")
@DependsOn(value={"ZXConfig"})
public class ZX10001HTMLServiceImpl
extends BaseZXService<ZX10001QueryReports, ZX10001HTMLResponseReport> {
    private static Logger log = LoggerFactory.getLogger(ZX10001HTMLServiceImpl.class);
    public static final String INTERFACE_ID = "10001";
    private final String vertType = "30";

    @Override
    protected void preProcess(BaseZXReqBean<ZX10001QueryReports> reqBean) {
        ZX10001QueryReports queryReports = (ZX10001QueryReports)reqBean.getQryRptsInfArry().get(0);
        queryReports = new ZX10001QueryReports.Builder().buildWithExists(queryReports).withIntfInd(INTERFACE_ID).withRptFmt("30").withRptAgng(config.getValidDay()).withCertTp("10100").withRtnType(ZXReturnType.HTML.VALUE).build();
        log.debug("\u8fdb\u5165\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\uff0c\u53c2\u6570\uff1a" + Objects.toString(queryReports));
    }

    @Override
    protected ZXVO postProcess(BaseZXReqBean<ZX10001QueryReports> reqBean, BaseZXResBean<ZX10001HTMLResponseReport> resBean) throws ESBException {
        try {
            String content = Optional.ofNullable(resBean.getContent()).orElseGet(String::new);
            String cusName = ((ZX10001QueryReports)reqBean.getQryRptsInfArry().get(0)).getCustNm();
            String certCode = ((ZX10001QueryReports)reqBean.getQryRptsInfArry().get(0)).getCertNo();
            ZXHtmlInfoVO zxHtmlInfo = new ZXHtmlInfoVO(cusName, certCode, content);
            return new ZXVO(Boolean.TRUE, (Object)zxHtmlInfo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return new ZXVO(Boolean.FALSE, null);
        }
    }

    @Override
    protected String tradeNo() {
        return "40130003";
    }

    @Override
    protected String scene() {
        return "01";
    }

    @Override
    protected Function<String, BaseZXResBean<ZX10001HTMLResponseReport>> converter() {
        return i -> (BaseZXResBean)JSONObject.parseObject((String)i, (TypeReference)new TypeReference<BaseZXResBean<ZX10001HTMLResponseReport>>(){}, (Feature[])new Feature[0]);
    }
}

