/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.impl.zx;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.Try;
import com.irdstudio.cdp.pboc.service.facade.QueryReportService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.facade.ZXJsonInfoService;
import com.irdstudio.cdp.pboc.service.vo.QueryReportVO;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.cdp.pboc.service.vo.ZXJsonInfoVO;
import com.irdstudio.efp.esb.service.bo.req.BaseNewZXReqBean;
import com.irdstudio.efp.esb.service.bo.req.ZXCXA01QueryReports;
import com.irdstudio.efp.esb.service.bo.resp.zx.BaseNewZXResBean;
import com.irdstudio.efp.esb.service.bo.resp.zx.ZXCXA01ResponseReport;
import com.irdstudio.efp.esb.service.impl.zx.BaseNewZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="zxCXA01Service")
public class ZXCXA01ServiceImpl
extends BaseNewZXService<ZXCXA01QueryReports, ZXCXA01ResponseReport> {
    private static Logger log = LoggerFactory.getLogger(ZXCXA01ServiceImpl.class);
    public static final String INTERFACE_ID = "10001";
    private final String vertType = "30";
    @Autowired
    @Qualifier(value="zxJsonInfoService")
    private ZXJsonInfoService zxJsonInfoService;
    @Autowired
    @Qualifier(value="zxHtmlInfoService")
    private ZXHtmlInfoService zxHtmlInfoService;
    @Autowired
    @Qualifier(value="queryReportService")
    private QueryReportService QueryReportService;

    @Override
    protected void preProcess(BaseNewZXReqBean<ZXCXA01QueryReports> reqBean) {
    }

    @Override
    protected String tradeNo() {
        return "40130015";
    }

    @Override
    protected String scene() {
        return "01";
    }

    @Override
    protected Function<String, BaseNewZXResBean<ZXCXA01ResponseReport>> converter() {
        return i -> (BaseNewZXResBean)JSONObject.parseObject((String)i, (TypeReference)new TypeReference<BaseNewZXResBean<ZXCXA01ResponseReport>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    protected ZXVO postProcess(BaseNewZXReqBean<ZXCXA01QueryReports> reqBean, BaseNewZXResBean<ZXCXA01ResponseReport> resBean) throws Exception {
        ZXCXA01ResponseReport rprtHeadStruct = resBean.getRprtHeadStruct();
        String reportId = rprtHeadStruct.getRprtNo();
        ZXVO zxvo = new ZXVO(Boolean.TRUE, (Object)reportId);
        ZXJsonInfoVO queryReportVo = new ZXJsonInfoVO();
        queryReportVo.setReportId(reportId);
        if (this.zxJsonInfoService.queryByPk(queryReportVo) != null) {
            log.info("\u5df2\u5b58\u5728\u67e5\u8be2\u7ed3\u679c\uff0c\u4e0d\u8fdb\u884c\u843d\u5e93\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
            return zxvo;
        }
        String reportTime = rprtHeadStruct.getRprtTm().replace("T", " ");
        String cusName = rprtHeadStruct.getBeQryPrsnNm();
        String certType = rprtHeadStruct.getBeQryPrsnIdentTp();
        String certCode = rprtHeadStruct.getBeQryPrsnIdentNo();
        String user = rprtHeadStruct.getQryBrchCd();
        String queryReason = rprtHeadStruct.getQryRsnCd();
        ZXJsonInfoVO ZXJsonInfoVO2 = new ZXJsonInfoVO();
        ZXJsonInfoVO2.setReportId(reportId);
        ZXJsonInfoVO2.setCusName(cusName);
        ZXJsonInfoVO2.setCertType(certType);
        ZXJsonInfoVO2.setCertCode(certCode);
        ZXJsonInfoVO2.setQueryReason(rprtHeadStruct.getQryRsnCd());
        ZXJsonInfoVO2.setJsonContent(resBean.getJSONFmtCrRfrncRprt());
        ZXJsonInfoVO2.setCreateTime(DateUtility.getCurrDateTime());
        ZXJsonInfoVO2.setReportTime(reportTime);
        ZXHtmlInfoVO zxHtmlInfoVO = new ZXHtmlInfoVO();
        zxHtmlInfoVO.setReportId(reportId);
        zxHtmlInfoVO.setCusName(cusName);
        zxHtmlInfoVO.setCertCode(certCode);
        byte[] bytes = Base64.decodeBase64((String)resBean.getHTMLFmtCrRfrncRprt());
        String html = new String(bytes, "UTF-8");
        zxHtmlInfoVO.setContent(html);
        QueryReportVO queryReport = new QueryReportVO();
        queryReport.setReportId(reportId);
        queryReport.setReportTime(reportTime);
        queryReport.setRequestTime(TimeUtil.getCurrentDateTime());
        queryReport.setCername(cusName);
        queryReport.setCertype(certType);
        queryReport.setCercode(certCode);
        queryReport.setUser(user);
        queryReport.setQueryReason(queryReason);
        Optional.ofNullable(zxHtmlInfoVO).ifPresent(Try.ofConsumer(arg_0 -> ((ZXHtmlInfoService)this.zxHtmlInfoService).insert(arg_0)));
        Optional.ofNullable(ZXJsonInfoVO2).ifPresent(Try.ofConsumer(arg_0 -> ((ZXJsonInfoService)this.zxJsonInfoService).insert(arg_0)));
        Optional.ofNullable(queryReport).ifPresent(Try.ofConsumer(arg_0 -> ((QueryReportService)this.QueryReportService).insertQueryReport(arg_0)));
        log.info("\u5f81\u4fe1JSON/XML/HTML\u683c\u5f0f\u67e5\u8be2\u7ed3\u679c\u843d\u5e93\u5b8c\u6210\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
        return zxvo;
    }
}

