/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.rule.service.impl;

import com.irdstudio.efp.rule.service.facade.DynamicExecuteDrools;
import com.irdstudio.efp.rule.service.util.DynamicExecuteDroolsFactory;
import com.irdstudio.efp.rule.service.vo.RuleEntity;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="dynamicExecuteDrools")
public class DynamicExecuteDroolsImpl
implements DynamicExecuteDrools {
    private static Logger logger = LoggerFactory.getLogger(DynamicExecuteDroolsImpl.class);

    public boolean dynamicExecuteDrools(String ruleName, String droolsScript, Map<String, Object> params) throws Exception {
        logger.info("\u52a8\u6001\u89c4\u5219\uff1a" + ruleName + "\u5f00\u59cb\u6267\u884c......");
        DynamicExecuteDroolsFactory factory = DynamicExecuteDroolsFactory.getFactory();
        KieSession kieSession = null;
        boolean result = false;
        try {
            if (!factory.exist(ruleName)) {
                String wholeDroolsScript = DynamicExecuteDroolsImpl.droolsScriptDeal(ruleName, droolsScript);
                kieSession = factory.createKieSession(ruleName, wholeDroolsScript);
            } else {
                kieSession = factory.createKieSession(ruleName, null);
            }
            kieSession.insert(params);
            kieSession.fireAllRules();
            Collection objects = kieSession.getObjects(new ObjectFilter(){

                public boolean accept(Object object) {
                    return Objects.nonNull(object) && object instanceof RuleEntity;
                }
            });
            if (Objects.nonNull(objects) && !objects.isEmpty()) {
                result = true;
            }
            logger.info("\u52a8\u6001\u89c4\u5219\uff1a" + ruleName + "\u6267\u884c\u7ed3\u679c\u4e3a:" + result);
        }
        catch (Exception e) {
            logger.error("\u52a8\u6001\u89c4\u5219\uff1a" + ruleName + "\u6267\u884c\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            throw e;
        }
        finally {
            if (Objects.nonNull(kieSession)) {
                kieSession.dispose();
            }
        }
        return result;
    }

    public void compileDynamicRule(String ruleName, String droolsScript) throws Exception {
        DynamicExecuteDroolsFactory factory = DynamicExecuteDroolsFactory.getFactory();
        String wholeDroolsScript = DynamicExecuteDroolsImpl.droolsScriptDeal(ruleName, droolsScript);
        if (!factory.exist(ruleName)) {
            factory.createKieSession(ruleName, wholeDroolsScript);
        } else {
            factory.rebuildRule(ruleName, wholeDroolsScript);
        }
    }

    protected static String droolsScriptDeal(String ruleName, String droolsScript) {
        StringBuilder sb = new StringBuilder();
        sb.append("package rules.RULE").append(ruleName).append("\r\n");
        sb.append("\r\n");
        sb.append("import com.irdstudio.efp.rule.service.vo.*;").append("\r\n");
        sb.append("import java.util.*;").append("\r\n");
        sb.append("import java.math.BigDecimal;").append("\r\n");
        sb.append("\r\n");
        sb.append("dialect  \"mvel\"").append("\r\n");
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append("rule '").append(ruleName).append("'").append("\r\n");
        sb.append("\t").append("lock-on-active true").append("\r\n");
        sb.append("\r\n");
        sb.append("\t").append("when").append("\r\n");
        sb.append("\t\t").append(droolsScript).append("\r\n");
        sb.append("\t").append("then").append("\r\n");
        sb.append("\t\t").append("insert(new RuleEntity(RuleEntity.PASS, drools.getRule().getName()));").append("\r\n");
        sb.append("end").append("\r\n");
        logger.info("\u6700\u7ec8\u751f\u6210\u7684\u52a8\u6001\u89c4\u5219\u4e3a:\r\n" + sb.toString());
        return sb.toString();
    }
}

