/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.rule.service.impl;

import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.efp.rule.common.enumeration.Rule;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import com.irdstudio.efp.rule.service.vo.ReqRuleVo;
import com.irdstudio.efp.rule.service.vo.RespRuleVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ruleCallService")
public class RuleCallServiceImpl
implements RuleCallService {
    private static Logger logger = LoggerFactory.getLogger(RuleCallServiceImpl.class);
    private static ObjectFilter objectFilter = object -> Objects.nonNull(object) && object instanceof RespRuleVO;

    public synchronized List<RespRuleVO> executeBatchRule(Rule.RuleType rule, ReqRuleVo param) {
        KieSession kieSession = (KieSession)SpringContextUtils.getBean((String)rule.toString());
        logger.info("\u4e1a\u52a1\u6d41\u6c34\u53f7\uff1a" + param.getAppNo() + "\u89c4\u5219\u8c03\u7528\u5f00\u59cb\uff0c\u8c03\u7528\u89c4\u5219\u96c6id\uff1a " + rule.toString() + "  \u8c03\u7528\u53c2\u6570\uff1a" + param.toString());
        List<RespRuleVO> list = null;
        try {
            kieSession.insert((Object)param);
            kieSession.fireAllRules(i -> true);
            list = Optional.ofNullable(kieSession.getObjects(objectFilter)).orElseGet(ArrayList::new).stream().map(RespRuleVO.class::cast).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw e;
        }
        finally {
            kieSession.dispose();
            kieSession.destroy();
        }
        logger.info("\u4e1a\u52a1\u6d41\u6c34\u53f7\uff1a" + param.getAppNo() + "\u89c4\u5219\u8c03\u7528\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + list);
        return list;
    }
}

