/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.rule.service.impl;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.efp.rule.service.dao.TaxAuthInfoDao;
import com.irdstudio.efp.rule.service.dao.TaxBasicInfoDao;
import com.irdstudio.efp.rule.service.domain.TaxAuthInfo;
import com.irdstudio.efp.rule.service.domain.TaxBasicInfo;
import com.irdstudio.efp.rule.service.facade.TaxAllInfoService;
import com.irdstudio.efp.rule.service.impl.RuleCallServiceImpl;
import com.irdstudio.efp.rule.service.vo.TaxBasicInfoVO;
import com.irdstudio.efp.rule.service.vo.TaxInfoMainVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taxAllInfoService")
public class TaxAllInfoServiceImpl
implements TaxAllInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(RuleCallServiceImpl.class);
    @Autowired
    private TaxAuthInfoDao taxAuthInfoDao;
    @Autowired
    private TaxBasicInfoDao taxBasicInfoDao;

    public List<TaxInfoMainVO> queryAllInfoByConditon(TaxInfoMainVO taxInfoMainVO) {
        logger.info("\u6b63\u5728\u67e5\u8be2\u7eb3\u7a0e\u4fe1\u606f");
        ArrayList<TaxInfoMainVO> taxInfoMainVOList = new ArrayList<TaxInfoMainVO>();
        return taxInfoMainVOList;
    }

    private TaxInfoMainVO transferBean(TaxBasicInfo taxBasicInfo, TaxAuthInfo taxAuthInfo) {
        TaxInfoMainVO taxInfoMainVO = new TaxInfoMainVO();
        this.beanCopy((Object)taxBasicInfo, taxInfoMainVO);
        if (taxAuthInfo != null) {
            taxInfoMainVO.setAuthBank(taxAuthInfo.getAuthBank());
            taxInfoMainVO.setAuthDt(taxAuthInfo.getAuthDt());
            taxInfoMainVO.setAuthEndDt(taxAuthInfo.getAuthEndDt());
            taxInfoMainVO.setAuthFlowNo(taxAuthInfo.getAuthFlowNo());
            taxInfoMainVO.setAuthrCertNo(taxAuthInfo.getAuthrCertNo());
            taxInfoMainVO.setApplyDt(taxBasicInfo.getCreateTime().substring(0, 10));
            taxInfoMainVO.setCertNo(taxBasicInfo.getCertNo());
            taxInfoMainVO.setCrdtAppFlowNo(taxBasicInfo.getCrdtAppFlowNo());
            taxInfoMainVO.setTaxpyNm(taxBasicInfo.getTaxpyNm());
        }
        return taxInfoMainVO;
    }

    public TaxBasicInfoVO queryByCrdtAppFlowNo(TaxBasicInfoVO inTaxBasicInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inTaxBasicInfoVO);
        try {
            TaxBasicInfo queryTaxBasicInfo = new TaxBasicInfo();
            this.beanCopy(inTaxBasicInfoVO, (Object)queryTaxBasicInfo);
            TaxBasicInfo queryRslTaxBasicInfo = this.taxBasicInfoDao.queryByCrdtAppFlowNo(queryTaxBasicInfo);
            if (Objects.nonNull((Object)queryRslTaxBasicInfo)) {
                TaxBasicInfoVO outTaxBasicInfoVo = (TaxBasicInfoVO)this.beanCopy((Object)queryRslTaxBasicInfo, new TaxBasicInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outTaxBasicInfoVo.toString());
                return outTaxBasicInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<TaxBasicInfoVO> queryAllOwner(TaxBasicInfoVO taxBasicInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<TaxBasicInfo> taxBasicInfoVOS = this.taxBasicInfoDao.queryAllOwnerByPage(taxBasicInfoVO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + taxBasicInfoVOS.size());
            this.pageSet(taxBasicInfoVOS, (BaseInfo)taxBasicInfoVO);
            list = (List)this.beansCopy(taxBasicInfoVOS, TaxBasicInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<TaxBasicInfoVO> queryAllCurrOrg(TaxBasicInfoVO taxBasicInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<TaxBasicInfo> taxBasicInfoVOS = this.taxBasicInfoDao.queryAllCurrOrgByPage(taxBasicInfoVO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + taxBasicInfoVOS.size());
            this.pageSet(taxBasicInfoVOS, (BaseInfo)taxBasicInfoVO);
            list = (List)this.beansCopy(taxBasicInfoVOS, TaxBasicInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<TaxBasicInfoVO> queryAllCurrDownOrg(TaxBasicInfoVO taxBasicInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<TaxBasicInfo> taxBasicInfoVOS = this.taxBasicInfoDao.queryAllCurrDownOrgByPage(taxBasicInfoVO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + taxBasicInfoVOS.size());
            this.pageSet(taxBasicInfoVOS, (BaseInfo)taxBasicInfoVO);
            list = (List)this.beansCopy(taxBasicInfoVOS, TaxBasicInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<TaxBasicInfoVO> queryAllCurrOwnerPrd(TaxBasicInfoVO taxBasicInfoVO) {
        logger.debug("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<TaxBasicInfo> taxBasicInfoVOS = this.taxBasicInfoDao.queryAllCurrOwnerPrdByPage(taxBasicInfoVO);
            logger.debug("\u5f53\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + taxBasicInfoVOS.size());
            this.pageSet(taxBasicInfoVOS, (BaseInfo)taxBasicInfoVO);
            list = (List)this.beansCopy(taxBasicInfoVOS, TaxBasicInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<TaxInfoMainVO> queryAllInfoLimit(TaxInfoMainVO taxInfoMainVO, String dataRuleLimit) {
        logger.info("\u6b63\u5728\u67e5\u8be2\u7eb3\u7a0e\u4fe1\u606f\uff0c\u6570\u636e\u6743\u9650\u4e3a\uff1a" + dataRuleLimit);
        ArrayList<TaxInfoMainVO> taxInfoMainVOList = new ArrayList<TaxInfoMainVO>();
        List taxBasicInfoVOList = new ArrayList();
        TaxBasicInfoVO taxBasicInfoVO = new TaxBasicInfoVO();
        this.beanCopy(taxInfoMainVO, taxBasicInfoVO);
        taxBasicInfoVO.setCreateTime(taxInfoMainVO.getApplyDt());
        taxBasicInfoVOList = Optional.ofNullable(this.dataRuleFilterByPage(taxBasicInfoVO, dataRuleLimit)).orElseGet(ArrayList::new);
        this.pageSet(taxBasicInfoVOList, (BaseInfo)taxBasicInfoVO);
        TaxAuthInfo taxAuthInfo = new TaxAuthInfo();
        for (TaxBasicInfo innerTaxBasicInfo : taxBasicInfoVOList) {
            TaxAuthInfo innerTaxAuthInfo = new TaxAuthInfo();
            taxAuthInfo.setCrdtAppFlowNo(innerTaxBasicInfo.getCrdtAppFlowNo());
            innerTaxAuthInfo = this.taxAuthInfoDao.queryByCrdtAppFlowNo(taxAuthInfo);
            TaxInfoMainVO innertaxInfoMainVO = null;
            innertaxInfoMainVO = this.transferBean(innerTaxBasicInfo, innerTaxAuthInfo);
            if (innertaxInfoMainVO == null) continue;
            taxInfoMainVOList.add(innertaxInfoMainVO);
        }
        return taxInfoMainVOList;
    }

    private List<TaxBasicInfo> dataRuleFilterByPage(TaxBasicInfoVO queryTaxBasicInfo, String dataRuleType) {
        List<TaxBasicInfo> result = null;
        switch (dataRuleType) {
            case "01": {
                result = this.taxBasicInfoDao.queryAllOwnerByPage(queryTaxBasicInfo);
                break;
            }
            case "02": {
                result = this.taxBasicInfoDao.queryAllCurrOrgByPage(queryTaxBasicInfo);
                break;
            }
            case "03": {
                result = this.taxBasicInfoDao.queryAllCurrDownOrgByPage(queryTaxBasicInfo);
                break;
            }
            case "04": {
                result = this.taxBasicInfoDao.queryAllCurrOwnerPrdByPage(queryTaxBasicInfo);
                break;
            }
            default: {
                result = this.taxBasicInfoDao.queryAllCurrDownOrgByPage(queryTaxBasicInfo);
            }
        }
        return result;
    }
}

