/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.rule.service.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicExecuteDroolsFactory {
    private static Logger logger = LoggerFactory.getLogger(DynamicExecuteDroolsFactory.class);
    private static Map<String, KieBase> dynamicKBaseMap = new ConcurrentHashMap<String, KieBase>();
    private static final DynamicExecuteDroolsFactory _INSTANCE = DynamicExecuteDroolsFactoryHandler.access$000();

    private DynamicExecuteDroolsFactory() {
    }

    public static DynamicExecuteDroolsFactory getFactory() {
        return _INSTANCE;
    }

    public KieSession createKieSession(String key, String dynamicDroolsStr) throws Exception {
        this.findOrCreate(key, dynamicDroolsStr);
        return dynamicKBaseMap.get(key).newKieSession();
    }

    private void findOrCreate(String key, String dynamicDroolsStr) throws Exception {
        if (!dynamicKBaseMap.containsKey(key)) {
            this.createKieBase(key, dynamicDroolsStr);
        }
    }

    private void createKieBase(String key, String dynamicDroolsStr) throws Exception {
        try {
            KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kb.add(ResourceFactory.newByteArrayResource((byte[])dynamicDroolsStr.getBytes("utf-8")), ResourceType.DRL);
            KnowledgeBuilderErrors errors = kb.getErrors();
            ArrayList<String> errorMsg = new ArrayList<String>();
            for (KnowledgeBuilderError error : errors) {
                logger.error(error.getMessage());
                errorMsg.add(error.getMessage() + "\r\n");
            }
            if (!errorMsg.isEmpty()) {
                throw new Exception(((Object)errorMsg).toString());
            }
            KnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
            kBase.addKnowledgePackages(kb.getKnowledgePackages());
            dynamicKBaseMap.put(key, (KieBase)kBase);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean exist(String key) {
        return dynamicKBaseMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildRule(String key, String rule) throws Exception {
        if (dynamicKBaseMap.containsKey(key)) {
            try {
                Map<String, KieBase> map = dynamicKBaseMap;
                synchronized (map) {
                    dynamicKBaseMap.remove(key);
                    this.createKieBase(key, rule);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                dynamicKBaseMap.notify();
                throw e;
            }
        }
    }

    private static class DynamicExecuteDroolsFactoryHandler {
        private static final DynamicExecuteDroolsFactory factory = new DynamicExecuteDroolsFactory();

        private DynamicExecuteDroolsFactoryHandler() {
        }

        static /* synthetic */ DynamicExecuteDroolsFactory access$000() {
            return factory;
        }
    }
}

