/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.rule.service.util;

import com.irdstudio.efp.rule.common.enumeration.CreditCardType;
import com.irdstudio.efp.rule.common.enumeration.LoanStatus;
import com.irdstudio.efp.rule.common.enumeration.TelAprvQResult;
import com.irdstudio.efp.rule.service.vo.CreditCardEntity;
import com.irdstudio.efp.rule.service.vo.CreditCardOverdueEntity;
import com.irdstudio.efp.rule.service.vo.CreditQueryEntity;
import com.irdstudio.efp.rule.service.vo.CreditRepaymentEntity;
import com.irdstudio.efp.rule.service.vo.PayTaxUnitEntity;
import com.irdstudio.efp.rule.service.vo.TelAprvCfg;
import com.irdstudio.efp.rule.service.vo.TelAprvResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class RuleUtil {
    private static final SimpleDateFormat MONTH_SDF = new SimpleDateFormat("yyyyMM");
    private static final SimpleDateFormat DAY_SDF = new SimpleDateFormat("yyyyMMdd");
    public static final String PARAM = "Param";
    public static final String VALUE = "Value";
    public static final String SENSITIVE_REMARK = "\u80a1\u7968\u3001\u57fa\u91d1\u3001\u7406\u8d22\u3001\u9ec4\u91d1\u3001\u7968\u636e\u3001\u623f\u3001\u4e09\u65b9\u3001\u94f6\u8f6c\u8bc1\u3001\u4e2d\u4ecb\u3001\u7f6e\u4e1a\u3001\u7269\u4e1a\u3001\u7ecf\u7eaa\u3001\u8bc1\u5238\u3001\u6295\u8d44\u3001\u5b9e\u4e1a\u3001\u8d44\u4ea7\u3001\u62c5\u4fdd\u3001\u8d44\u672c\u91d1\u3001\u9996\u671f\u3001\u9996\u4ed8\u6b3e\u3001\u878d\u8d44";
    public static final String SENSITIVE_SUMMARY = "01GL\u300101ml\u300101tf\u300101vk\u300101b0\u300101vn\u300112D3\u300112EH\u300112ml\u300101DH\u300101az\u300101vm\u300101bq\u300112c9\u300112vm\u300101rl\u300112H2\u300101H2\u300101td\u300112DH\u300112az\u300112gi\u300112hw\u300112rl\u300101D3\u300101EH\u300101kR\u300112FW\u300112GL\u300112b0\u300112kR\u300112z9\u300112XR\u300112bq\u300112iw\u300112td";

    public static List<CreditCardOverdueEntity> getAllovers(List<CreditCardEntity> cards) {
        ArrayList<CreditCardOverdueEntity> overs = new ArrayList<CreditCardOverdueEntity>();
        if (cards != null && cards.size() > 0) {
            for (int i = 0; i < cards.size(); ++i) {
                if (null == cards.get(i).getOverdueInfos() || cards.get(i).getOverdueInfos().size() <= 0) continue;
                List temps = cards.get(i).getOverdueInfos();
                for (CreditCardOverdueEntity over : temps) {
                    over.setStandDate(cards.get(i).getEndYearMonth());
                    over.setCardNo(cards.get(i).getCardNo());
                }
                overs.addAll(temps);
            }
        }
        return overs;
    }

    public static List<CreditCardOverdueEntity> getAllOversByType(List<CreditCardEntity> cards, CreditCardType cardType) {
        ArrayList<CreditCardOverdueEntity> overs = new ArrayList<CreditCardOverdueEntity>();
        if (cards != null && cards.size() > 0) {
            for (int i = 0; i < cards.size(); ++i) {
                CreditCardEntity card = cards.get(i);
                if (null == card.getOverdueInfos() || card.getCardType() != cardType || card.getOverdueInfos().size() <= 0) continue;
                List temps = cards.get(i).getOverdueInfos();
                for (CreditCardOverdueEntity over : temps) {
                    over.setStandDate(cards.get(i).getEndYearMonth());
                    over.setCardNo(cards.get(i).getCardNo());
                }
                overs.addAll(temps);
            }
        }
        return overs;
    }

    public static List<CreditCardOverdueEntity> getAllOversByType(List<CreditCardEntity> cards, CreditCardType cardType, CreditCardType deCardType) {
        ArrayList<CreditCardOverdueEntity> overs = new ArrayList<CreditCardOverdueEntity>();
        if (cards != null && cards.size() > 0) {
            for (int i = 0; i < cards.size(); ++i) {
                CreditCardEntity card = cards.get(i);
                if (null == card.getOverdueInfos() || card.getCardType() != cardType && card.getCardType() != deCardType || card.getOverdueInfos().size() <= 0) continue;
                List temps = cards.get(i).getOverdueInfos();
                for (CreditCardOverdueEntity over : temps) {
                    over.setStandDate(cards.get(i).getEndYearMonth());
                    over.setCardNo(cards.get(i).getCardNo());
                }
                overs.addAll(temps);
            }
        }
        return overs;
    }

    public static List<CreditRepaymentEntity> getAllRepays(List<CreditCardEntity> cards) {
        ArrayList<CreditRepaymentEntity> repays = new ArrayList<CreditRepaymentEntity>();
        if (cards != null && cards.size() > 0) {
            for (int i = 0; i < cards.size(); ++i) {
                if (null == cards.get(i).getRepayInfos() || cards.get(i).getRepayInfos().size() <= 0) continue;
                List temps = cards.get(i).getRepayInfos();
                for (CreditRepaymentEntity repay : temps) {
                    repay.setStandDate(cards.get(i).getEndYearMonth());
                }
                repays.addAll(cards.get(i).getRepayInfos());
            }
        }
        return repays;
    }

    public static boolean isMonthBetween(String date, Object month, String standDate) {
        int m = 0;
        boolean flag = false;
        try {
            m = Integer.parseInt(month.toString());
            date = RuleUtil.executeDate(date, 6);
            Date time = MONTH_SDF.parse(date);
            Calendar nowCal = Calendar.getInstance();
            if (StringUtils.isNotEmpty((String)standDate)) {
                standDate = RuleUtil.executeDate(standDate, 6);
                Date stand = MONTH_SDF.parse(standDate);
                nowCal.setTime(stand);
            }
            Calendar dateCal = Calendar.getInstance();
            dateCal.setTime(time);
            int diffMonth = (nowCal.get(1) - dateCal.get(1)) * 12 + (nowCal.get(2) - dateCal.get(2));
            if (diffMonth < m) {
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public static boolean isMatches(String regex, String str) {
        if (null == str) {
            return false;
        }
        boolean flag = Pattern.matches(regex, str);
        return flag;
    }

    public static int loanBankTotal(List<CreditCardEntity> cards) {
        int banks = 0;
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        if (null != cards && cards.size() > 0) {
            for (int i = 0; i < cards.size(); ++i) {
                CreditCardEntity card = cards.get(i);
                if (card.getCardType() == CreditCardType.DEBIT_CARD || card.getCardType() == CreditCardType.SEMI_CREDIT_CARD) continue;
                if (null == temp.get(card.getBankNo())) {
                    ++banks;
                    temp.put(card.getBankNo(), 1);
                    continue;
                }
                temp.put(card.getBankNo(), (Integer)temp.get(card.getBankNo()) + 1);
            }
        }
        return banks;
    }

    public static int noCloLoanBankTotal(List<CreditCardEntity> cards) {
        int banks = 0;
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        if (null != cards && cards.size() > 0) {
            for (int i = 0; i < cards.size(); ++i) {
                CreditCardEntity card = cards.get(i);
                if (card == null || card.getCardType() == CreditCardType.DEBIT_CARD || card.getCardType() == CreditCardType.SEMI_CREDIT_CARD || !RuleUtil.isMatches("^[a-zA-Z0-9]+$", card.getBankNo()) || card.getLoanStatus() == LoanStatus.CLOSE_OVER) continue;
                if (null == temp.get(card.getBankNo())) {
                    ++banks;
                    temp.put(card.getBankNo(), 1);
                    continue;
                }
                temp.put(card.getBankNo(), (Integer)temp.get(card.getBankNo()) + 1);
            }
        }
        return banks;
    }

    public static Map<String, Double> getTelAprvQTypePassRate(List<TelAprvResult> rlts) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (null != rlts && rlts.size() > 0) {
            double total = 0.0;
            double passTotal = 0.0;
            for (int i = 0; i < rlts.size(); ++i) {
                TelAprvResult rlt = rlts.get(i);
                if (null == map.get(rlt.getqType())) {
                    passTotal = rlt.getqRtl() == TelAprvQResult.PASS ? 1.0 : 0.0;
                    total = 1.0;
                    map.put(rlt.getqType() + "PassTotal", passTotal);
                    map.put(rlt.getqType() + "Total", total);
                    map.put(rlt.getqType(), passTotal / total * 100.0);
                    continue;
                }
                total = (Double)map.get(rlt.getqType() + "Total") + 1.0;
                passTotal = (Double)map.get(rlt.getqType() + "PassTotal");
                if (rlt.getqRtl() == TelAprvQResult.PASS) {
                    passTotal += 1.0;
                }
                map.put(rlt.getqType() + "PassTotal", passTotal);
                map.put(rlt.getqType() + "Total", total);
                map.put(rlt.getqType(), passTotal / total * 100.0);
            }
        }
        return map;
    }

    public static int getNoPassTotal(List<TelAprvCfg> cfgs, Map<String, Double> qTypeRate) {
        if (null == qTypeRate || qTypeRate.size() == 0) {
            return -1;
        }
        int total = 0;
        if (null != cfgs && cfgs.size() > 0) {
            for (int i = 0; i < cfgs.size(); ++i) {
                TelAprvCfg cfg = cfgs.get(i);
                Double passRate = qTypeRate.get(cfg.getqType());
                if (null == passRate || null == cfg.getPassRate() || !(passRate < cfg.getPassRate().doubleValue())) continue;
                ++total;
            }
        }
        return total;
    }

    public static boolean isStartCreditQuery(List<CreditQueryEntity> querys, Object creditQueryTremDay) {
        boolean flag = false;
        if (null != querys && querys.size() > 0) {
            Date temp = new Date();
            Date lastQuery = new Date();
            try {
                for (int i = 0; i < querys.size(); ++i) {
                    String queryDate = querys.get(i).getQueryDate();
                    queryDate = RuleUtil.executeDate(queryDate, 8);
                    lastQuery = DAY_SDF.parse(queryDate);
                    if (i <= 0 || (temp = DAY_SDF.parse(queryDate)).getTime() <= lastQuery.getTime()) continue;
                    lastQuery = temp;
                }
                int day = Integer.parseInt(creditQueryTremDay.toString());
                Calendar lastCal = Calendar.getInstance();
                lastCal.setTime(lastQuery);
                lastCal.add(5, day);
                Date now = new Date();
                if (lastCal.getTime().getTime() <= now.getTime()) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }

    public static boolean isCurrentTermDate(String date) {
        boolean flag = false;
        try {
            date = RuleUtil.executeDate(date, 6);
            Date overDate = MONTH_SDF.parse(date);
            Calendar overCal = Calendar.getInstance();
            overCal.setTime(overDate);
            Calendar cal = Calendar.getInstance();
            if (overCal.get(1) == cal.get(1) && overCal.get(2) == cal.get(2)) {
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isContainsSensitive(String info, String sensitiveParam) {
        boolean flag = false;
        if (!StringUtils.isEmpty((String)info)) {
            String[] sensitives = sensitiveParam.split("\u3001");
            for (int i = 0; i < sensitives.length; ++i) {
                if (!info.contains(sensitives[i])) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static int getDaysBetweenTwoDates(String date1, String date2) {
        int result = 0;
        try {
            date1 = RuleUtil.executeDate(date1, 8);
            date2 = RuleUtil.executeDate(date2, 8);
            long d1 = DAY_SDF.parse(date1).getTime();
            long d2 = DAY_SDF.parse(date2).getTime();
            result = (int)((d2 - d1) / 1000L / 60L / 60L / 24L);
            result = result < 0 ? result * -1 : result;
        }
        catch (Exception e) {
            result = -1;
        }
        return result;
    }

    public static int getRealDaysBetweenTwoDates(String date1, String date2) {
        int result = 0;
        try {
            date1 = RuleUtil.executeDate(date1, 8);
            date2 = RuleUtil.executeDate(date2, 8);
            long d1 = DAY_SDF.parse(date1).getTime();
            long d2 = DAY_SDF.parse(date2).getTime();
            result = (int)((d2 - d1) / 1000L / 60L / 60L / 24L);
        }
        catch (Exception e) {
            result = -1;
        }
        return result;
    }

    public static int getMonthsBetweenTwoDates(String date1, String date2) {
        int result = 0;
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            date1 = RuleUtil.executeDate(date1, 6);
            date2 = RuleUtil.executeDate(date2, 6);
            c1.setTime(MONTH_SDF.parse(date1));
            c2.setTime(MONTH_SDF.parse(date2));
            result = (c2.get(1) - c1.get(1)) * 12 + c2.get(2) - c1.get(2);
        }
        catch (Exception e) {
            result = -1;
        }
        return result;
    }

    public static String executeDate(String date, int length) {
        String result = null;
        try {
            result = date.replaceAll("\\D", "");
            result = result.substring(0, length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<CreditCardOverdueEntity> sortSmallCardOver(List<CreditCardOverdueEntity> overs) {
        if (null == overs || overs.size() == 0) {
            return overs;
        }
        int size = overs.size();
        ArrayList<CreditCardOverdueEntity> resOvers = new ArrayList<CreditCardOverdueEntity>(size);
        int l = 0;
        for (int i = 0; i < size; ++i) {
            CreditCardOverdueEntity min = overs.get(0);
            l = 0;
            for (int j = 1; j < overs.size(); ++j) {
                CreditCardOverdueEntity temp = overs.get(j);
                if (temp == null || RuleUtil.monthDateToInt(temp.getOverDueDate()) >= RuleUtil.monthDateToInt(min.getOverDueDate())) continue;
                min = temp;
                l = j;
            }
            resOvers.add(min);
            overs.remove(l);
        }
        return resOvers;
    }

    public static int monthDateToInt(String date) {
        int i = 0;
        try {
            if (null != date) {
                date = RuleUtil.executeDate(date, 6);
                i = Integer.parseInt(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static boolean putParamInfo(String param, String val, Map<String, String> ruleParams) {
        if (null != ruleParams) {
            ruleParams.put(param + PARAM, val);
        }
        return true;
    }

    public static boolean putValInfo(String param, String val, Map<String, String> ruleParams) {
        if (null != ruleParams) {
            ruleParams.put(param + VALUE, val);
        }
        return true;
    }

    public static boolean isStandDayBig(String date, String standDay, int addDays) {
        boolean flag = false;
        try {
            date = RuleUtil.executeDate(date, 6);
            standDay = RuleUtil.executeDate(standDay, 8);
            Date standDate = DAY_SDF.parse(standDay);
            Calendar standCal = Calendar.getInstance();
            standCal.setTime(standDate);
            standCal.add(5, addDays);
            Date d = MONTH_SDF.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            int diffMonth = (cal.get(1) - standCal.get(1)) * 12 + (cal.get(2) - standCal.get(2));
            flag = diffMonth >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public static boolean twoDateMonthDiff(String date1, String date2) {
        int diff = 0;
        try {
            diff = RuleUtil.getMonthsBetweenTwoDates(date2, date1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return diff == 1;
    }

    public static String getYearMonth(String date) {
        String result = null;
        try {
            result = date.replaceAll("\\D", "");
            result = result.substring(0, 6);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static Integer getYearMonthInt(String date) {
        Integer result = null;
        try {
            String ym = date.replaceAll("\\D", "");
            ym = ym.substring(0, 6);
            result = Integer.valueOf(ym);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getTaxType(String uniform, List<PayTaxUnitEntity> payTaxUnits) {
        if (StringUtils.isEmpty((String)uniform)) {
            return null;
        }
        if (null != payTaxUnits && payTaxUnits.size() > 0) {
            for (PayTaxUnitEntity payTax : payTaxUnits) {
                if (!uniform.equals(payTax.getUniformSociCreditCode())) continue;
                return payTax.getTaxType();
            }
        }
        return null;
    }
}

