/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.agent.core.engine;

import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.plugins.core.BatchRunProcess;
import com.irdstudio.sdk.plugins.core.dao.JavaDataJobDao;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.util.DataMoveUtil;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.util.TableMove;
import com.irdstudio.sdk.plugins.core.utils.pub.ConnectionUtil;
import com.irdstudio.sdk.plugins.core.vo.BaseVo;
import com.irdstudio.sdk.plugins.core.vo.BatBatchInfoConfig;
import com.irdstudio.sdk.plugins.core.vo.BatInstBatch;
import com.irdstudio.sdk.plugins.core.vo.BatInstTask;
import com.irdstudio.sdk.plugins.core.vo.BatTaskUnitConfig;
import com.irdstudio.sdk.plugins.core.vo.SSubsInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BpmRunEngine {
    private static final String BATCH_RUN = "run";
    private static final String BATCH_STOP = "stop";
    private static final String BATCH_RERUN = "rerun";
    private static final String BATCH_CONTINUE = "continue";
    private String batchAction;
    private String batchId;
    private String batchSerialNo;

    public BpmRunEngine(String batchAction, String batchId, String batchSerialNo) {
        this.batchId = batchId;
        this.batchSerialNo = batchSerialNo;
        this.batchAction = batchAction.toLowerCase();
    }

    public void start() throws Exception {
        if (BATCH_RUN.equals(this.batchAction)) {
            this.doRunBatch();
        } else if (BATCH_STOP.equals(this.batchAction)) {
            this.doStopBatch();
        } else if (BATCH_RERUN.equals(this.batchAction)) {
            this.doRerunBatch();
        } else if (BATCH_CONTINUE.equals(this.batchAction)) {
            this.doContinueBatch();
        }
    }

    private void doRunBatch() throws Exception {
        Connection conn = null;
        ArrayList<String> values = new ArrayList<String>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            String sql = "select count(1) from bat_inst_batch where batch_serial_no = ?";
            values.clear();
            values.add(this.batchSerialNo);
            int count = dao.queryCount(sql, values);
            if (count > 0) {
                throw new Exception("\u5f53\u524d\u4e1a\u52a1\u6d41\u6c34\u53f7\u5df2\u7ecf\u53d1\u8d77\u6279\u6b21\uff0c\u4e0d\u5141\u8bb8\u518d\u53d1\u8d77\uff01");
            }
            sql = "select * from bat_batch_info_config where batch_id = ?";
            values.clear();
            values.add(this.batchId);
            BatBatchInfoConfig batBatchInfoConfig = (BatBatchInfoConfig)dao.querySingle(sql, values, BatBatchInfoConfig.class);
            if (Objects.isNull(batBatchInfoConfig)) {
                throw new Exception("\u83b7\u53d6\u6279\u6b21\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String subsCode = batBatchInfoConfig.getSubsCode();
            if (StringUtils.isBlank((CharSequence)subsCode)) {
                throw new Exception("\u83b7\u53d6\u6279\u6b21\u6240\u5c5e\u7cfb\u7edf\u4ee3\u7801\u4e3a\u7a7a\uff01");
            }
            sql = "select * from s_subs_info where subs_code = ?";
            values.clear();
            values.add(subsCode);
            SSubsInfo sSubsInfo = (SSubsInfo)dao.querySingle(sql, values, SSubsInfo.class);
            if (sSubsInfo == null) {
                throw new Exception("\u6839\u636e\u5b50\u7cfb\u7edf\u4ee3\u7801\u3010" + subsCode + "\u3011\u67e5\u8be2\u5b50\u7cfb\u7edf\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String batchDate = TimeUtil.getCurDate();
            BatInstBatch batInstBatch = new BatInstBatch();
            batInstBatch.setBatchSerialNo(this.batchSerialNo);
            batInstBatch.setBatchId(batBatchInfoConfig.getBatchId());
            batInstBatch.setBatchName(batBatchInfoConfig.getBatchName());
            batInstBatch.setBatchState("8");
            batInstBatch.setBatchInterveneState("0");
            batInstBatch.setBatchDate(batchDate);
            batInstBatch.setStartTime(TimeUtil.getCurrentDateTime());
            batInstBatch.setSubsCode(sSubsInfo.getSubsCode());
            dao.insertAuto((BaseVo)batInstBatch);
            sql = "insert into bat_inst_task (batch_serial_no, task_id, task_name, batch_id, batch_date, stage_id, stage_name, task_run_state, task_intervene_state) select '" + this.batchSerialNo + "' as batch_serial_no, a.task_id, a.task_name, b.batch_id, '" + batchDate + "' as batch_date, a.stage_id, b.stage_name, '" + "0" + "' as task_run_state, '" + "0" + "' as task_intervene_state " + "from bat_task_unit_config a, bat_batch_stage_config b where a.batch_id = '" + this.batchId + "' and a.task_use_state = '0' and (a.task_use_area = '1' or a.task_use_area = '2') and a.batch_id = b.batch_id  and a.stage_id = b.stage_id";
            count = dao.update(sql);
            if (count > 0) {
                String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
                BatchRunProcess batRunProcess = new BatchRunProcess(this.batchSerialNo, batBatchInfoConfig, logPath);
                batRunProcess.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doStopBatch() throws Exception {
        Connection conn = null;
        String sql = null;
        ArrayList<String> values = new ArrayList<String>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            sql = "select * from bat_batch_info_config where batch_id = ?";
            values.add(this.batchId);
            BatBatchInfoConfig batBatchInfoConfig = (BatBatchInfoConfig)dao.querySingle(sql, values, BatBatchInfoConfig.class);
            if (batBatchInfoConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            sql = "select * from bat_inst_task where batch_serial_no = ? and task_run_state = ?";
            values.clear();
            values.add(this.batchSerialNo);
            values.add("2");
            List batInstTaskList = dao.queryList(sql, values, BatInstTask.class);
            if (batInstTaskList == null || batInstTaskList.size() == 0) {
                throw new Exception("\u5f53\u524d\u6279\u6b21\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff01");
            }
            Iterator it = batInstTaskList.iterator();
            while (it.hasNext()) {
                String taskId = ((BatInstTask)it.next()).getTaskId();
                sql = "select * from bat_task_unit_config where previous_task_id = ?";
                values.clear();
                values.add(taskId);
                List batTaskUnitConfigList = dao.queryList(sql, values, BatTaskUnitConfig.class);
                if (batTaskUnitConfigList.size() == 0) continue;
                Iterator batTaskUnitConfigIt = batTaskUnitConfigList.iterator();
                while (batTaskUnitConfigIt.hasNext()) {
                    String nextTaskId = ((BatTaskUnitConfig)batTaskUnitConfigIt.next()).getTaskId();
                    sql = "update bat_inst_task set task_run_state = ? where batch_serial_no = ? and task_id = ?";
                    values.clear();
                    values.add("7");
                    values.add(this.batchSerialNo);
                    values.add(nextTaskId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doRerunBatch() throws Exception {
        Connection conn = null;
        String sql = null;
        ArrayList<String> values = new ArrayList<String>();
        try {
            conn = ConnectionUtil.getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            sql = "select * from bat_batch_info_config where batch_id = ?";
            values.add(this.batchId);
            BatBatchInfoConfig batchConfig = (BatBatchInfoConfig)dao.querySingle(sql, values, BatBatchInfoConfig.class);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String isRunAgain = batchConfig.getIsRunAgain();
            if (StringUtils.isBlank((CharSequence)isRunAgain)) {
                throw new Exception("\u67e5\u8be2\u662f\u5426\u5141\u8bb8\u91cd\u8dd1\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if ("N".equals(isRunAgain)) {
                throw new Exception("\u8be5\u6279\u6b21\u4e0d\u652f\u6301\u91cd\u8dd1\uff01");
            }
            sql = "select * from bat_inst_batch where batch_serial_no = ?";
            values.clear();
            values.add(this.batchSerialNo);
            BatInstBatch batchInst = (BatInstBatch)dao.querySingle(sql, values, BatInstBatch.class);
            if (batchInst == null) {
                throw new Exception("\u672a\u627e\u5230\u91cd\u8dd1\u7684\u6279\u6b21\uff01");
            }
            String batchState = batchInst.getBatchState();
            if ("8".equals(batchState) || "3".equals(batchState)) {
                throw new Exception("\u6279\u6b21\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u91cd\u8dd1\uff01");
            }
            String cond = " where batch_id = '" + this.batchId + "'";
            this.dataMove(conn, "bat_inst_batch", "bat_inst_batch_h", cond);
            this.dataMove(conn, "bat_inst_task", "bat_inst_task_h", cond);
            String condi1 = " where batch_id = '" + this.batchId + "'";
            TableMove batchDataMoveUtil = DataMoveUtil.createTableMoveInst((Connection)conn, (String)"bat_inst_batch", (String)"bat_inst_batch");
            batchDataMoveUtil.setCondition(condi1);
            String batchSerialNo = batchInst.getBatchSerialNo();
            String lastTwoSerial = batchSerialNo.substring(batchSerialNo.length() - 1, batchSerialNo.length());
            lastTwoSerial = Integer.parseInt(lastTwoSerial) < 10 ? "0" + (Integer.parseInt(lastTwoSerial) + 1) : "" + (Integer.parseInt(lastTwoSerial) + 1);
            batchSerialNo = batchSerialNo.substring(0, batchSerialNo.length() - 2) + lastTwoSerial;
            batchDataMoveUtil.addValueMapping("batch_serial_no", (Object)batchSerialNo);
            batchDataMoveUtil.addValueMapping("batch_order", (Object)(batchInst.getBatchOrder() + 1));
            batchDataMoveUtil.executeCopy();
            String condi = " where batch_id = '" + this.batchId + "' and task_use_state='0' and (task_use_area = '1' or task_use_area = '3') ";
            TableMove taskDataMoveUtil = DataMoveUtil.createTableMoveInst((Connection)conn, (String)"bat_task_unit_config", (String)"bat_inst_task");
            taskDataMoveUtil.setCondition(condi);
            taskDataMoveUtil.executeCopy();
            String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
            BatchRunProcess batRunProcess = new BatchRunProcess(this.batchSerialNo, batchConfig, logPath);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ConnectionUtil.releaseConnection((Connection)conn);
        }
    }

    private void doContinueBatch() throws Exception {
        Connection conn = null;
        String sql = null;
        ArrayList<String> values = new ArrayList<String>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            sql = "select * from bat_batch_info_config where batch_id = ?";
            values.add(this.batchId);
            BatBatchInfoConfig batchConfig = (BatBatchInfoConfig)dao.querySingle(sql, values, BatBatchInfoConfig.class);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            sql = "update bat_inst_task set task_run_state=?, start_time='', end_time='', cost_time=0 where batch_serial_no=? and task_run_state='7'";
            values.clear();
            values.add("1");
            values.add(this.batchSerialNo);
            dao.update(sql, values);
            String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
            BatchRunProcess batRunProcess = new BatchRunProcess(this.batchSerialNo, batchConfig, logPath);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public void dataMove(Connection conn, String srcTableName, String destTableName, String cond) throws SQLException {
        TableMove dataMoveInst = DataMoveUtil.createTableMoveInst((Connection)conn, (String)srcTableName, (String)destTableName);
        dataMoveInst.setCondition(cond);
        dataMoveInst.executeCut();
    }
}

