/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.agent.core.engine;

import com.irdstudio.sdk.agent.core.init.AgentInstInfo;
import com.irdstudio.sdk.agent.core.job.ScheduleJob;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.plugins.core.dao.JavaDataJobDao;
import com.irdstudio.sdk.plugins.core.plugin.dubbo.DubboClient;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.sdk.plugins.core.vo.SSrvsCronConf;
import com.irdstudio.sdk.plugins.core.vo.SSrvsCronInst;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzJobEngine
implements Job {
    private static Logger logger = Logger.getLogger(QuartzJobEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Connection conn = null;
        String result = "";
        boolean isHaveError = false;
        String jobCode = jobExecutionContext.getJobDetail().getKey().getName();
        long startMills = System.currentTimeMillis();
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            sql = "select * from s_srvs_cron_inst where job_code = ?";
            values.clear();
            values.add(jobCode);
            SSrvsCronInst cronInst = (SSrvsCronInst)dao.querySingle(sql, values, SSrvsCronInst.class);
            if (cronInst == null) {
                logger.info((Object)(jobCode + "\u5c1a\u672a\u521d\u59cb\u5316!"));
                return;
            }
            if (1 == cronInst.getState()) {
                StringBuffer sb = new StringBuffer(cronInst.getJobDesc());
                sb.append("(").append(jobCode).append(")\u6b63\u5728\u7531").append(cronInst.getAgentId()).append("\u8fd0\u884c!");
                logger.info((Object)sb);
                return;
            }
            if (!AgentInstInfo.AGENT_ID.equals(cronInst.getAgentId())) {
                StringBuffer sb = new StringBuffer(cronInst.getJobDesc());
                sb.append("(").append(jobCode).append(")\u53ea\u80fd\u7531").append(cronInst.getAgentId()).append("\u8fd0\u884c!!!");
                logger.error((Object)sb);
                return;
            }
            sql = "select * from s_srvs_cron_conf where job_code = ?";
            values.clear();
            values.add(jobCode);
            SSrvsCronConf cronConf = (SSrvsCronConf)dao.querySingle(sql, values, SSrvsCronConf.class);
            if (cronConf == null) {
                logger.info((Object)(jobCode + "\u914d\u7f6e\u5f02\u5e38!"));
                return;
            }
            logger.info((Object)new StringBuffer("\u5f00\u59cb\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]..."));
            sql = "update s_srvs_cron_inst set state=?, start_time=?, result_desc='\u6b63\u5728\u8fd0\u884c...' where job_code = ?";
            values.clear();
            values.add(1);
            values.add(TimeUtil.getCurrentDateTime());
            values.add(jobCode);
            dao.update(sql, values);
            logger.info((Object)("\u6267\u884c\u4f5c\u4e1a\u7c7b:" + cronConf.getJobClass() + ",\u65b9\u6cd5:" + cronConf.getJobMethod()));
            if ("hsf".equals(cronConf.getJobClassType())) {
                logger.info((Object)"HSF\u670d\u52a1\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb......");
            } else if ("dubbo".equals(cronConf.getJobClassType())) {
                logger.info((Object)"DUBBO\u670d\u52a1\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb......");
                GenericService svc = null;
                svc = cronConf.getServiceTimeout() == null ? DubboClient.getDubboClient().buildGenericService(cronConf.getJobClass(), cronConf.getServiceGroup(), cronConf.getServiceVersion()) : DubboClient.getDubboClient().buildGenericService(cronConf.getJobClass(), cronConf.getServiceTimeout().intValue(), cronConf.getServiceGroup(), cronConf.getServiceVersion());
                String[] paramTypeArr = null;
                Object[] paramValueArr = null;
                logger.info((Object)("service id: " + cronConf.getServiceId() + ", interface: " + cronConf.getJobClass() + ",version: " + cronConf.getServiceVersion() + ", group: " + cronConf.getServiceGroup() + ",timeout: " + cronConf.getServiceTimeout() + ", param type: " + paramTypeArr + ", param value: " + paramValueArr));
                Object ivkResult = svc.$invoke(cronConf.getJobMethod(), paramTypeArr, paramValueArr);
                logger.info((Object)("service call ivkResult: " + ivkResult));
                logger.info((Object)"DUBBO\u670d\u52a1\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f");
            } else {
                logger.info((Object)("\u672c\u5730\u65b9\u6cd5" + cronConf.getJobClass() + "\u8c03\u7528\u5f00\u59cb......"));
                Object job = Class.forName(cronConf.getJobClass()).newInstance();
                if (ScheduleJob.class.isInstance(job)) {
                    ((ScheduleJob)job).doExcetue(conn, cronConf);
                    logger.info((Object)"ScheduleJob -- \u672c\u5730\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f\uff01");
                } else {
                    Method method = job.getClass().getMethod(cronConf.getJobMethod(), new Class[0]);
                    method.invoke(job, null);
                    logger.info((Object)"\u672c\u5730\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f\uff01");
                }
            }
            this.updateStateToEnd(dao, jobCode, startMills, isHaveError, result);
            logger.info((Object)new StringBuffer("\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]\u5b8c\u6210..."));
        }
        catch (SQLException e) {
            isHaveError = true;
            result = e.getMessage();
            logger.error((Object)e);
            e.printStackTrace();
            this.updateStateToEnd(dao, jobCode, startMills, isHaveError, result);
            logger.info((Object)new StringBuffer("\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]\u53d1\u751f\u9519\u8bef..."));
        }
        catch (Exception e) {
            isHaveError = true;
            result = e.getMessage();
            logger.error((Object)e);
            e.printStackTrace();
            this.updateStateToEnd(dao, jobCode, startMills, isHaveError, result);
            logger.info((Object)new StringBuffer("\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]\u53d1\u751f\u9519\u8bef..."));
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void updateStateToEnd(JavaDataJobDao dao, String jobCode, long startMills, boolean isHaveError, String result) {
        int state = isHaveError ? 9 : 2;
        long endMills = System.currentTimeMillis();
        BigDecimal costTime = new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            result = result.substring(0, 3999);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "update s_srvs_cron_inst set state=?, end_time=?, cost_time=?, result_desc=? where job_code = ?";
        values.add(state);
        values.add(TimeUtil.getCurrentDateTime());
        values.add(costTime);
        values.add(result);
        values.add(jobCode);
        dao.update(sql, values);
        sql = "insert into s_srvs_cron_his(record_id,job_code,job_desc,state,start_time,end_time,cost_time,agent_id,result_desc) select '" + this.createUUIDKey() + "',job_code,job_desc,state,start_time,end_time,cost_time,agent_id,result_desc from s_srvs_cron_inst where job_code = '" + jobCode + "'";
        values.clear();
        dao.insert(sql);
    }

    private String createUUIDKey() {
        return UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }
}

