/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.agent.core.init;

import com.irdstudio.sdk.agent.core.init.AgentInstInfo;
import com.irdstudio.sdk.beans.core.util.PathUtil;
import com.irdstudio.sdk.plugins.core.tinycore.log.ILogger;
import com.irdstudio.sdk.plugins.core.tinycore.log.TLogger;
import java.io.File;
import java.util.ResourceBundle;

public class AgentResourceLoader {
    private static AgentResourceLoader inst = null;
    private String projectRootPath = "";
    private ILogger logger = null;

    public static synchronized AgentResourceLoader me() {
        if (inst == null) {
            inst = new AgentResourceLoader();
        }
        return inst;
    }

    public void loadGlobalConfigure() {
        this.projectRootPath = PathUtil.getProjectRootPath();
        ResourceBundle bundle = ResourceBundle.getBundle("application");
        AgentInstInfo.BATCH_LOG_PATH = this.formatPath(bundle.getString("agent.batch.log.path"));
        AgentInstInfo.AGENT_MODE = bundle.getString("agent.mode");
        AgentInstInfo.AGENT_ID = bundle.getString("agent.id");
        File file = new File(AgentInstInfo.BATCH_LOG_PATH);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.logger.info((Object)(" \u6279\u6b21\u670d\u52a1\u65e5\u5fd7\u8def\u5f84 :" + AgentInstInfo.BATCH_LOG_PATH));
    }

    private String formatPath(String path) {
        if (PathUtil.isAbsolutePath((String)path)) {
            return path;
        }
        return this.projectRootPath + path;
    }

    public void start() {
        this.logger = TLogger.getLogger((String)"resource");
        this.loadGlobalConfigure();
    }
}

