/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.agent.core.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@Configuration
public class DruidConfig {
    private static final Logger logger = LoggerFactory.getLogger(DruidConfig.class);
    @Value(value="${dataSource.url}")
    private String dbUrl;
    @Value(value="${dataSource.username}")
    private String username;
    @Value(value="${dataSource.password}")
    private String password;
    @Value(value="${dataSource.driverClassName}")
    private String driverClassName;
    @Value(value="${dataSource.initialSize}")
    private int initialSize;
    @Value(value="${dataSource.minIdle}")
    private int minIdle;
    @Value(value="${dataSource.maxActive}")
    private int maxActive;
    @Value(value="${dataSource.maxWait}")
    private int maxWait;
    @Value(value="${dataSource.timeBetweenEvictionRunsMillis}")
    private int timeBetweenEvictionRunsMillis;
    @Value(value="${dataSource.minEvictableIdleTimeMillis}")
    private int minEvictableIdleTimeMillis;
    @Value(value="${dataSource.validationQuery}")
    private String validationQuery;
    @Value(value="${dataSource.testWhileIdle}")
    private boolean testWhileIdle;
    @Value(value="${dataSource.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${dataSource.testOnReturn}")
    private boolean testOnReturn;
    @Value(value="${dataSource.poolPreparedStatements}")
    private boolean poolPreparedStatements;
    @Value(value="${dataSource.filters}")
    private String filters;
    @Value(value="${dataSource.logSlowSql}")
    private String logSlowSql;
    @Value(value="${dataSource.connectionProperties}")
    private String connectionProperties;
    @Value(value="${dataSource.maxPoolPreparedStatementPerConnectionSize}")
    private int maxPoolPreparedStatementPerConnectionSize;
    @Value(value="${dataSource.removeAbandonedTimeout}")
    private int removeAbandonedTimeout;
    @Value(value="${dataSource.logAbandoned}")
    private boolean logAbandoned;
    @Autowired
    WallFilter wallFilter;

    @Bean
    @Primary
    public DataSource dataSource() throws Exception {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dbUrl);
        datasource.setUsername(this.username);
        datasource.setPassword(this.password);
        datasource.setDriverClassName(this.driverClassName);
        datasource.setInitialSize(this.initialSize);
        datasource.setMinIdle(this.minIdle);
        datasource.setMaxActive(this.maxActive);
        datasource.setMaxWait((long)this.maxWait);
        datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
        datasource.setValidationQuery(this.validationQuery);
        datasource.setTestWhileIdle(this.testWhileIdle);
        datasource.setTestOnBorrow(this.testOnBorrow);
        datasource.setTestOnReturn(this.testOnReturn);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements);
        datasource.setConnectionProperties(this.connectionProperties);
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
        datasource.setRemoveAbandonedTimeout(this.removeAbandonedTimeout);
        datasource.setLogAbandoned(this.logAbandoned);
        ArrayList<WallFilter> filter = new ArrayList<WallFilter>();
        filter.add(this.wallFilter);
        datasource.setProxyFilters(filter);
        try {
            datasource.setFilters(this.filters);
        }
        catch (SQLException e) {
            logger.error("\u6570\u636e\u6e90\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
        }
        return datasource;
    }

    @Bean
    public ServletRegistrationBean druidServlet() throws Exception {
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.setServlet((Servlet)new StatViewServlet());
        reg.addUrlMappings(new String[]{"/druid/*"});
        reg.addInitParameter("loginUsername", this.username);
        reg.addInitParameter("loginPassword", this.password);
        reg.addInitParameter("logSlowSql", this.logSlowSql);
        return reg;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new WebStatFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        filterRegistrationBean.addInitParameter("profileEnable", "true");
        return filterRegistrationBean;
    }

    @Bean(name={"wallConfig"})
    WallConfig wallFilterConfiug() {
        WallConfig wc = new WallConfig();
        wc.setMultiStatementAllow(true);
        wc.setNoneBaseStatementAllow(true);
        return wc;
    }

    @Bean(name={"wallFilter"})
    @DependsOn(value={"wallConfig"})
    WallFilter wallFilter(WallConfig wallConfig) {
        WallFilter wallFilter = new WallFilter();
        wallFilter.setConfig(wallConfig);
        return wallFilter;
    }
}

