/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.agent.core.schedule;

import com.irdstudio.sdk.agent.core.engine.QuartzJobEngine;
import com.irdstudio.sdk.agent.core.init.AgentInstInfo;
import com.irdstudio.sdk.agent.core.schedule.QuartzManager;
import com.irdstudio.sdk.plugins.core.dao.JavaDataJobDao;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.sdk.plugins.core.vo.SSrvsCronConf;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ScheduleJobUtil {
    public static final int STATE_INITIALIZE = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_END = 2;
    public static final int STATE_ERROR = 9;
    private static Logger logger = Logger.getLogger(ScheduleJobUtil.class);
    public static String JOB_GROUP_NAME = "AGENT_JOB_GROUP";
    public static String TRIGGER_NAME = "AGENT_TRIGGER";
    public static String TRIGGER_GROUP_NAME = "AGENT_TRIGGER_GROUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJobsForAgent() {
        logger.info((Object)"\u5f00\u59cb\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            ArrayList<String> values = new ArrayList<String>();
            String sql = "select * from s_srvs_cron_conf where agent_id = ?";
            values.add(AgentInstInfo.AGENT_ID);
            List cronConfList = dao.queryList(sql, values, SSrvsCronConf.class);
            for (SSrvsCronConf cronConf : cronConfList) {
                if (!AgentInstInfo.AGENT_ID.equals(cronConf.getAgentId())) continue;
                logger.info((Object)("\u52a0\u5165\u5b9a\u65f6\u4efb\u52a1\uff1a" + cronConf.getJobDesc() + "..."));
                QuartzManager.addJob(cronConf.getJobCode(), JOB_GROUP_NAME, TRIGGER_NAME + "-" + cronConf.getJobCode(), TRIGGER_GROUP_NAME, QuartzJobEngine.class, cronConf.getCronExpression());
                sql = "delete from s_srvs_cron_inst where job_code = ?";
                values.clear();
                values.add(cronConf.getJobCode());
                dao.delete(sql, values);
                sql = "insert into s_srvs_cron_inst(job_code,job_desc,state,start_time,end_time,cost_time,agent_id,result_desc) select job_code,job_desc,'0','','',0,agent_id,'\u5df2\u521d\u59cb\u5316,\u7b49\u5f85\u89e6\u53d1...' from s_srvs_cron_conf where job_code = '" + cronConf.getJobCode() + "'";
                dao.insert(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        logger.info((Object)"\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }

    public static void stopJobsForAgent() {
        logger.info((Object)"\u5f00\u59cb\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        try {
            QuartzManager.shutdownJobs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info((Object)"\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }
}

