/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.base;

import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;

public interface FrameworkService {
    default public <T> T beanCopy(Object srcBean, Object targetBean) {
        if (Objects.nonNull(targetBean) && Objects.nonNull(srcBean)) {
            BeanCopier beanCopier = BeanCopier.create(srcBean.getClass(), targetBean.getClass(), (boolean)false);
            beanCopier.copy(srcBean, targetBean, null);
            return (T)targetBean;
        }
        return null;
    }

    default public <T> Collection<? extends Object> beansCopy(Collection<? extends Object> srcBeans, Class<?> targetBean) throws Exception {
        if (Objects.isNull(srcBeans)) {
            return null;
        }
        return srcBeans.stream().map(s -> this.beanCopy(s, this.newInstance(targetBean))).collect(Collectors.toList());
    }

    default public <T> List<T> beansCopy(List<? extends Object> srcBeans, Class<T> targetBean) throws Exception {
        if (Objects.isNull(srcBeans)) {
            return null;
        }
        return srcBeans.stream().map(s -> this.beanCopy(s, this.newInstance(targetBean))).collect(Collectors.toList());
    }

    default public void pageSet(Collection<? extends BaseInfo> queryRtnBean, BaseInfo queryCondBean) {
        if (Objects.nonNull(queryRtnBean) && !queryRtnBean.isEmpty() && Objects.nonNull(queryCondBean)) {
            queryRtnBean.stream().forEach(s -> {
                s.setLoginUserId(queryCondBean.getLoginUserId());
                s.setLoginUserLeageOrgCode(queryCondBean.getLoginUserLeageOrgCode());
                s.setLoginUserOrgCode(queryCondBean.getLoginUserOrgCode());
                s.setLoginUserOrgLocation(queryCondBean.getLoginUserOrgLocation());
                s.setPage(queryCondBean.getPage());
                s.setSize(queryCondBean.getSize());
                s.setTotal(queryCondBean.getTotal());
            });
        }
    }

    default public Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Class\u7c7b\u5bf9\u8c61:" + clazz.getName() + "\u5b9e\u4f8b\u5316\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    default public <T> T setInsertDefaultProperty(BaseInfo baseInfo) {
        try {
            BeanUtils.setProperty((Object)baseInfo, (String)"createTime", (Object)TimeUtil.getCurrentDateTime());
            BeanUtils.setProperty((Object)baseInfo, (String)"lastUpdateTime", (Object)TimeUtil.getCurrentDateTime());
            BeanUtils.setProperty((Object)baseInfo, (String)"createUser", (Object)baseInfo.getLoginUserId());
            BeanUtils.setProperty((Object)baseInfo, (String)"lastUpdateUser", (Object)baseInfo.getLoginUserId());
            BeanUtils.setProperty((Object)baseInfo, (String)"legalOrgCode", (Object)baseInfo.getLoginUserLeageOrgCode());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("\u8bbe\u7f6e\u65b0\u589e\u9ed8\u8ba4\u5c5e\u6027\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return (T)baseInfo;
    }

    default public <T> T setUpdateDefaultProperty(BaseInfo baseInfo) {
        try {
            BeanUtils.setProperty((Object)baseInfo, (String)"lastUpdateTime", (Object)TimeUtil.getCurrentDateTime());
            BeanUtils.setProperty((Object)baseInfo, (String)"lastUpdateUser", (Object)baseInfo.getLoginUserId());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("\u8bbe\u7f6e\u4fee\u6539\u9ed8\u8ba4\u5c5e\u6027\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return (T)baseInfo;
    }
}

