/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.annotation.BeanMapKey;
import com.irdstudio.sdk.beans.core.util.GsonUtils;
import com.irdstudio.sdk.beans.core.util.ReflectUtility;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;

public class BeanUtility {
    public static Map<String, Object> bean2MapByBeanMap(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            HashMap<String, Object> rtnMap = new HashMap<String, Object>();
            BeanMap beanMap = BeanMap.create((Object)bean);
            for (Object key : beanMap.keySet()) {
                Object value = beanMap.get(key);
                if (!Objects.nonNull(value)) continue;
                if (value instanceof String || value instanceof Number) {
                    rtnMap.put(key + "", value);
                    continue;
                }
                if (value instanceof List) {
                    rtnMap.put(key + "", BeanUtility.listBean2ListByBeanMap(value));
                    continue;
                }
                rtnMap.put(key + "", BeanUtility.bean2MapByBeanMap(value));
            }
            return rtnMap;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }

    public static <T> T map2BeanByJSON(Map<String, Object> dataMap, Object bean) {
        String gson = GsonUtils.toJson(dataMap);
        return (T)GsonUtils.getJson(gson, bean.getClass());
    }

    public static List<Map<String, Object>> listBean2ListByBeanMap(Object obj) {
        List list = (List)obj;
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (Object listObj : list) {
            Map<String, Object> beanMap = BeanUtility.bean2MapByBeanMap(listObj);
            listMap.add(beanMap);
        }
        return listMap;
    }

    public static <T> T list2BeanList(List<Map<String, Object>> list, Class<?> clazz) throws Exception {
        ArrayList<T> bean = new ArrayList<T>();
        for (Map<String, Object> dataMap : list) {
            Object object = clazz.newInstance();
            bean.add(BeanUtility.map2Bean(dataMap, object));
        }
        return (T)bean;
    }

    public static <T> T map2Bean(Map<String, Object> dataMap, Object bean) {
        if (Objects.isNull(bean)) {
            throw new NullPointerException("exchange object must not null!");
        }
        if (Objects.isNull(dataMap) || dataMap.isEmpty()) {
            return (T)bean;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!dataMap.containsKey(key) || "class".equals(key)) continue;
                Object value = dataMap.get(key);
                if (value instanceof String || value instanceof Number) {
                    property.getWriteMethod().invoke(bean, value);
                    continue;
                }
                if (value instanceof List) continue;
                Class<?> clazz = property.getPropertyType();
                Object obj = clazz.newInstance();
                Map beanMap = (Map)value;
                obj = BeanUtility.map2Bean(beanMap, obj);
                property.getWriteMethod().invoke(bean, obj);
            }
            return (T)bean;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("map2Bean fail: " + e.getMessage(), e);
        }
    }

    public static List<Map<String, Object>> listBean2List(Object obj) {
        List list = (List)obj;
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (Object listObj : list) {
            Map<String, Object> beanMap = BeanUtility.bean2Map(listObj);
            listMap.add(beanMap);
        }
        return listMap;
    }

    public static Map<String, Object> bean2Map(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            HashMap<String, Object> beanMap = new HashMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method method;
                String key = property.getName();
                if (key.equals("class") || (method = property.getReadMethod()) == null) continue;
                Object value = method.invoke(bean, new Object[0]);
                if (property.getPropertyType().isAssignableFrom(String.class) || property.getPropertyType().isAssignableFrom(Number.class)) {
                    beanMap.put(key, value);
                    continue;
                }
                if (value instanceof List) {
                    beanMap.put(key, BeanUtility.listBean2List(value));
                    continue;
                }
                beanMap.put(key, BeanUtility.bean2Map(value));
            }
            return beanMap;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> bean2MapCleanNull(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            HashMap<String, Object> beanMap = new HashMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Object value;
                Method method;
                String key = property.getName();
                if (key.equals("class") || (method = property.getReadMethod()) == null || (value = method.invoke(bean, new Object[0])) == null) continue;
                if (property.getPropertyType().isAssignableFrom(String.class) || property.getPropertyType().isAssignableFrom(Number.class)) {
                    beanMap.put(key, value);
                    continue;
                }
                if (value instanceof List) {
                    beanMap.put(key, BeanUtility.listBean2List(value));
                    continue;
                }
                beanMap.put(key, BeanUtility.bean2Map(value));
            }
            return beanMap;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }

    public static <T> T beanCopy(Object srcBean, Object targetBean) {
        if (Objects.nonNull(targetBean) && Objects.nonNull(srcBean)) {
            BeanCopier beanCopier = BeanCopier.create(srcBean.getClass(), targetBean.getClass(), (boolean)false);
            beanCopier.copy(srcBean, targetBean, null);
            return (T)targetBean;
        }
        return null;
    }

    public static Map<String, Object> bean2MapByAnno(Object bean) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean instanceof Map) {
            return (Map)bean;
        }
        if (Objects.nonNull(bean)) {
            Field[] fields;
            for (Field field : fields = bean.getClass().getDeclaredFields()) {
                BeanMapKey beanMap = field.getAnnotation(BeanMapKey.class);
                if (!Objects.nonNull(beanMap)) continue;
                field.setAccessible(true);
                Object obj = field.get(bean);
                if (!(obj instanceof String || obj instanceof Number || obj instanceof Boolean)) {
                    obj = obj instanceof List ? BeanUtility.listBean2MapByAnno((List)obj) : BeanUtility.bean2MapByAnno(obj);
                }
                map.put(beanMap.value(), obj);
            }
        }
        return map;
    }

    public static List<Object> listBean2MapByAnno(List<Object> list) throws Exception {
        ArrayList<Object> listMap = new ArrayList<Object>();
        if (Objects.nonNull(list) && !list.isEmpty()) {
            Object o = list.get(0);
            if (o instanceof String || o instanceof Number || o instanceof Boolean) {
                return list;
            }
            for (Object obj : list) {
                listMap.add(BeanUtility.bean2MapByAnno(obj));
            }
        }
        return listMap;
    }

    public static <T> T map2BeanByAnno(Map<String, Object> dataMap, Class<T> clazz) throws Exception {
        T t = clazz.newInstance();
        return BeanUtility.map2BeanByAnno(dataMap, t);
    }

    public static <T> T map2BeanByAnno(Map<String, Object> dataMap, T object) throws Exception {
        if (Objects.nonNull(dataMap) && !dataMap.isEmpty() && Objects.nonNull(object)) {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                Class<?> clz;
                BeanMapKey beanMap = field.getAnnotation(BeanMapKey.class);
                if (!Objects.nonNull(beanMap)) continue;
                field.setAccessible(true);
                Object valObj = dataMap.get(beanMap.value());
                if (Objects.isNull(valObj) || StringUtil.isEmpty(valObj.toString())) continue;
                if (valObj instanceof List) {
                    ParameterizedType type = (ParameterizedType)field.getGenericType();
                    clz = (Class<?>)type.getActualTypeArguments()[0];
                    valObj = BeanUtility.list2BeanByAnno((List)valObj, clz);
                } else if (valObj instanceof Map) {
                    Object generClass = field.get(object);
                    clz = null;
                    clz = Objects.isNull(generClass) ? Class.forName(field.getGenericType().getTypeName()) : generClass.getClass();
                    valObj = BeanUtility.map2BeanByAnno((Map<String, Object>)((Map)valObj), clz);
                }
                field.set(object, valObj);
            }
        }
        return object;
    }

    public static List<Object> list2BeanByAnno(List<Object> list, Class<?> clazz) throws Exception {
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (Objects.nonNull(list) && !list.isEmpty() && Objects.nonNull(clazz)) {
            if (clazz.isAssignableFrom(Map.class)) {
                for (Object obj : list) {
                    Map dataMap = (Map)obj;
                    dataList.add(BeanUtility.map2BeanByAnno((Map<String, Object>)dataMap, clazz));
                }
            } else {
                dataList.add(list);
            }
        }
        return dataList;
    }

    public static Object getProptery(Object object, String name) throws Exception {
        String clazz = object.getClass().getName();
        if (clazz.matches(".+Map$")) {
            return object.getClass().getMethod("get", Object.class).invoke(object, name);
        }
        if (object instanceof Collection) {
            return null;
        }
        if (object instanceof String || object instanceof Number) {
            return object;
        }
        Field field = ReflectUtility.getObjectFiled(object, name);
        if (Objects.nonNull(field)) {
            return ReflectUtility.getObjectFieldValue(object, field);
        }
        return null;
    }

    public static final void setProptery(Object bean, String name, Object value) throws Exception {
        Field field = ReflectUtility.getObjectFiled(bean, name);
        if (Objects.nonNull(field)) {
            ReflectUtility.setObjectFieldValue(bean, field, ReflectUtility.convert(value, field.getType()));
        }
    }

    public static Map<String, Object> beanAll2Map(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }
}

