/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

public class ReflectUtility {
    public static final Object convert(Object object, Class<?> convertClass) throws Exception {
        Object rtnObject = null;
        if (Objects.nonNull(convertClass) && Objects.nonNull(object)) {
            if (Objects.equals(convertClass, object.getClass())) {
                rtnObject = object;
            }
            String strObject = String.valueOf(object);
            if (String.class.isAssignableFrom(convertClass)) {
                rtnObject = strObject;
            }
            if (Number.class.isAssignableFrom(convertClass)) {
                Method method = ReflectUtility.getObjectMethod(convertClass, "valueOf", String.class);
                if (Objects.nonNull(method)) {
                    rtnObject = method.invoke(convertClass.newInstance(), strObject);
                } else {
                    method = ReflectUtility.getObjectMethod(convertClass, "valueOf", Long.class);
                    if (Objects.nonNull(method)) {
                        rtnObject = method.invoke(convertClass.newInstance(), Long.valueOf(strObject));
                    }
                }
            }
        }
        return rtnObject;
    }

    public static final Field getObjectFiled(Object bean, String name) throws Exception {
        Class<?> clazz = bean.getClass();
        return ReflectUtility.getObjectFiled(clazz, name);
    }

    public static final Field getObjectFiled(Class<?> clazz, String name) throws Exception {
        while (Objects.nonNull(clazz) && !clazz.getName().equals("java.lang.Object")) {
            Field field = clazz.getDeclaredField(name);
            if (Objects.nonNull(field)) {
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setObjectFieldValue(Object object, Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception exception) {
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getObjectFieldValue(Object object, Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception exception) {
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
        return null;
    }

    public static final Method getObjectMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        return Optional.of(clazz.getDeclaredMethod(name, parameterTypes)).orElse(clazz.getMethod(name, parameterTypes));
    }
}

