/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static Logger logger = LoggerFactory.getLogger(StringUtils.class);
    public static final String EMPTY_STR = "";

    public static synchronized String replaceNullByObj(Object obj) {
        if (obj == null) {
            return EMPTY_STR;
        }
        return String.valueOf(obj);
    }

    public static synchronized String convertDateFrom10To8(Object obj) {
        String temp = StringUtils.replaceNullByObj(obj);
        return temp.replaceAll("-", EMPTY_STR);
    }

    public static synchronized boolean stringIsEmptyOrNull(String param) {
        boolean cheakParamIsEmptyOrNull = false;
        if (param == null || EMPTY_STR.equals(param.trim())) {
            cheakParamIsEmptyOrNull = true;
            logger.info("\u53c2\u6570\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff01");
        }
        return cheakParamIsEmptyOrNull;
    }

    public static synchronized boolean stringsIsEmptyOrNull(String ... params) {
        boolean cheakParamsIsEmptyOrNull = false;
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null && !EMPTY_STR.equals(params[i].trim())) continue;
                cheakParamsIsEmptyOrNull = true;
                logger.info("\u53c2\u6570\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32\uff01");
                break;
            }
        } else {
            cheakParamsIsEmptyOrNull = true;
            logger.info("\u53c2\u6570\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32\uff01");
        }
        return cheakParamsIsEmptyOrNull;
    }

    public static synchronized void checkAndPrint(String sKey, String sName, boolean flag) throws Exception {
        if (flag && (sKey == null || sKey.equals(EMPTY_STR))) {
            throw new Exception("\u4f20\u5165\u53c2\u6570\u3010" + sName + "\u3011\u4e3a\u7a7a");
        }
        logger.info("\u4f20\u5165\u53c2\u6570\u3010" + sName + "\uff1a" + sKey + "\u3011\u3010\u662f\u5426\u5fc5\u8f93\uff1a" + flag + "\u3011\u5fc5\u8f93\u9879\u68c0\u67e5\u901a\u8fc7");
    }

    public static synchronized boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static synchronized String subStr(String source, int fixLength) {
        int splitPoint = 0;
        if (source == null) {
            source = EMPTY_STR;
        }
        char[] charArray = source.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            int ascii = Character.codePointAt(charArray, i);
            splitPoint = ascii >= 0 && ascii <= 255 ? ++splitPoint : (splitPoint += 2);
            if (splitPoint <= fixLength) continue;
            source = source.substring(0, i);
            break;
        }
        return source;
    }

    public static int countForStr(String src, String regx) {
        Pattern p = Pattern.compile(regx);
        Matcher matcher = p.matcher(src);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }
}

