/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public abstract class TarUtil {
    private static final String BASE_DIR = "";
    private static final String PATH = File.separator;
    private static final int BUFFER = 1024;
    private static final String EXT = ".tar";

    public static void archive(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        TarUtil.archive(srcFile, destPath);
    }

    public static void archive(File srcFile, File destFile) throws Exception {
        TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(destFile));
        TarUtil.archive(srcFile, taos, BASE_DIR);
        taos.flush();
        taos.close();
    }

    public static void archive(File srcFile) throws Exception {
        String name = srcFile.getName();
        String basePath = srcFile.getParent();
        String destPath = basePath + File.separator + name + EXT;
        TarUtil.archive(srcFile, destPath);
    }

    public static void archive(File srcFile, String destPath) throws Exception {
        TarUtil.archive(srcFile, new File(destPath));
    }

    public static void archive(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        TarUtil.archive(srcFile);
    }

    private static void archive(File srcFile, TarArchiveOutputStream taos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            TarUtil.archiveDir(srcFile, taos, basePath);
        } else {
            TarUtil.archiveFile(srcFile, taos, basePath);
        }
    }

    private static void archiveDir(File dir, TarArchiveOutputStream taos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files.length < 1) {
            TarArchiveEntry entry = new TarArchiveEntry(basePath + dir.getName() + PATH);
            taos.putArchiveEntry((ArchiveEntry)entry);
            taos.closeArchiveEntry();
        }
        for (File file : files) {
            TarUtil.archive(file, taos, basePath + dir.getName() + PATH);
        }
    }

    private static void archiveFile(File file, TarArchiveOutputStream taos, String dir) throws Exception {
        int count;
        TarArchiveEntry entry = new TarArchiveEntry(file.getName());
        entry.setSize(file.length());
        taos.putArchiveEntry((ArchiveEntry)entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[1024];
        while ((count = bis.read(data, 0, 1024)) != -1) {
            taos.write(data, 0, count);
        }
        bis.close();
        taos.closeArchiveEntry();
    }

    public static void dearchive(File srcFile) throws Exception {
        String basePath = srcFile.getParent();
        TarUtil.dearchive(srcFile, basePath);
    }

    public static void dearchive(File srcFile, File destFile) throws Exception {
        TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new FileInputStream(srcFile));
        TarUtil.dearchive(destFile, tais);
        tais.close();
    }

    public static void dearchive(File srcFile, String destPath) throws Exception {
        TarUtil.dearchive(srcFile, new File(destPath));
    }

    private static void dearchive(File destFile, TarArchiveInputStream tais) throws Exception {
        TarArchiveEntry entry = null;
        while ((entry = tais.getNextTarEntry()) != null) {
            String dir = destFile.getPath() + File.separator + entry.getName();
            File dirFile = new File(dir);
            TarUtil.fileProber(dirFile);
            if (entry.isDirectory()) {
                dirFile.mkdirs();
                continue;
            }
            TarUtil.dearchiveFile(dirFile, tais);
        }
    }

    public static void dearchive(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        TarUtil.dearchive(srcFile);
    }

    public static void dearchive(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        TarUtil.dearchive(srcFile, destPath);
    }

    private static void dearchiveFile(File destFile, TarArchiveInputStream tais) throws Exception {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        byte[] data = new byte[1024];
        while ((count = tais.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.close();
    }

    private static void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            TarUtil.fileProber(parentFile);
            parentFile.mkdir();
        }
    }

    public static void main(String[] args) {
        try {
            String path = "D:/luobo/tmpFile";
            TarUtil.archive(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

