/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.validate;

import com.irdstudio.sdk.beans.core.validate.SimpleJSR303Validator;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.ObjectUtils;

public class ValidationHelper {
    private static Logger logger = LoggerFactory.getLogger(ValidationHelper.class);

    public static void valid(Object bean) {
        if (ObjectUtils.isEmpty((Object)bean)) {
            return;
        }
        Set<ConstraintViolation<Object>> validateSet = SimpleJSR303Validator.validate(bean);
        if (CollectionUtils.isNotEmpty(validateSet)) {
            String messages = validateSet.stream().map(ConstraintViolation::getMessage).reduce((m1, m2) -> m1 + "," + m2).orElse("\u53c2\u6570\u8f93\u5165\u6709\u8bef\uff01");
            throw new IllegalArgumentException(messages);
        }
    }

    public static <T> void validClass(Object bean, Class<T> temp) {
        if (ObjectUtils.isEmpty((Object)bean)) {
            return;
        }
        BeanCopier beanCopier = BeanCopier.create(bean.getClass(), temp, (boolean)false);
        Object targetBean = null;
        try {
            Constructor<T> ctor = temp.getConstructor(null);
            targetBean = ctor.newInstance(null);
        }
        catch (Exception e) {
            return;
        }
        if (targetBean == null) {
            return;
        }
        beanCopier.copy(bean, targetBean, null);
        ValidationHelper.valid(targetBean);
    }

    public static void valid(Object bean, Object temp) {
        if (ObjectUtils.isEmpty((Object)bean)) {
            return;
        }
        BeanCopier beanCopier = BeanCopier.create(bean.getClass(), temp.getClass(), (boolean)false);
        if (temp == null) {
            return;
        }
        beanCopier.copy(bean, temp, null);
        ValidationHelper.valid(temp);
    }

    public static void validateValue(Class beanType, String propertyName, Object value, boolean throwExp) {
        Set<ConstraintViolation<Object>> validateSet = SimpleJSR303Validator.validateValue(beanType, propertyName, value);
        if (CollectionUtils.isNotEmpty(validateSet)) {
            String messages = validateSet.stream().map(ConstraintViolation::getMessage).reduce((m1, m2) -> m1 + "," + m2).orElse("\u53c2\u6570\u8f93\u5165\u6709\u8bef\uff01");
            if (throwExp) {
                throw new IllegalArgumentException(messages);
            }
            logger.error("\u6821\u9a8c\u4fe1\u606f {}", (Object)messages);
        }
    }
}

