/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.cache;

import com.irdstudio.sdk.beans.core.cache.Cache;
import com.irdstudio.sdk.beans.core.cache.CacheInitialize;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PiccsFrameworkCache
implements Cache {
    private static Logger logger = LoggerFactory.getLogger(PiccsFrameworkCache.class);
    private static Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();
    private Map<String, CacheInitialize> initCaches;

    @Override
    public <T> T get(String key) {
        return (T)cacheMap.get(key);
    }

    @Override
    public void add(String cacheKey, String key, Object value) {
        Object object = cacheMap.get(cacheKey);
        if (Objects.nonNull(object)) {
            if (object instanceof Map) {
                Map keyMap = (Map)object;
                keyMap.put(key, value);
            }
        } else {
            ConcurrentHashMap<String, Object> keyMap = new ConcurrentHashMap<String, Object>();
            keyMap.put(key, value);
            cacheMap.put(cacheKey, keyMap);
        }
    }

    @Override
    public void add(String cacheKey, Object cacheValue) {
        Object object = cacheMap.get(cacheKey);
        if (!Objects.equals(object, cacheValue)) {
            cacheMap.remove(cacheKey);
            cacheMap.put(cacheKey, cacheValue);
        }
    }

    @Override
    public boolean containsKey(String key) {
        return cacheMap.containsKey(key);
    }

    @Override
    public boolean reload() {
        this.destory();
        this.load();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reload(String cacheKey) {
        logger.info("\u7f13\u5b58\uff1a" + cacheKey + "\u91cd\u65b0\u52a0\u8f7d\u5f00\u59cb......");
        CacheInitialize cacheInit = this.initCaches.get(cacheKey);
        if (Objects.nonNull(cacheInit)) {
            Object cacheValue = cacheInit.getInitCacheObject();
            if (Objects.nonNull(cacheValue)) {
                Map<String, Object> map = cacheMap;
                synchronized (map) {
                    cacheMap.remove(cacheKey);
                    cacheMap.put(cacheKey, cacheValue);
                }
                logger.info("\u7f13\u5b58\uff1a" + cacheKey + "\u91cd\u65b0\u52a0\u8f7d\u7ed3\u675f......");
            } else {
                logger.warn("\u7f13\u5b58\uff1a" + cacheKey + "\u91cd\u65b0\u52a0\u8f7d\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a, \u653e\u5f03\u672c\u6b21\u91cd\u65b0\u52a0\u8f7d!");
            }
        } else {
            logger.warn("\u5f53\u524d\u9700\u8981\u91cd\u65b0\u52a0\u8f7d\u7684\u7f13\u5b58:" + cacheKey + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u52a0\u8f7d\u5bf9\u8c61!");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        if (Objects.nonNull(this.initCaches) && !this.initCaches.isEmpty()) {
            Map<String, Object> map = cacheMap;
            synchronized (map) {
                for (Map.Entry<String, CacheInitialize> entry : this.initCaches.entrySet()) {
                    String cacheKey = entry.getKey();
                    logger.info("\u7f13\u5b58:" + cacheKey + "\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\u5f00\u59cb......");
                    Object cacheValue = entry.getValue().getInitCacheObject();
                    if (Objects.nonNull(cacheValue) && StringUtil.isNotEmpty(cacheKey)) {
                        this.add(cacheKey, cacheValue);
                        logger.info("\u7f13\u5b58:" + cacheKey + "\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\u7ed3\u675f......");
                        continue;
                    }
                    logger.warn("\u7f13\u5b58\u8fd4\u56de\u7684Key\u6216Value\u4e3a\u7a7a, \u9057\u5f03\u5904\u7406!");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destory() {
        Map<String, Object> map = cacheMap;
        synchronized (map) {
            cacheMap.clear();
        }
    }

    public Map<String, CacheInitialize> getInitCaches() {
        return this.initCaches;
    }

    public void setInitCaches(Map<String, CacheInitialize> initCaches) {
        this.initCaches = initCaches;
    }
}

