/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManager {
    private static final Logger logger = LoggerFactory.getLogger(LogManager.class);

    public static final void info(String bizSerno, Object service, String method) {
        StackTraceElement ste = new RuntimeException().getStackTrace()[1];
        StringBuffer sb = new StringBuffer();
        sb.append(ste.getClassName()).append(".").append(ste.getMethodName()).append(":").append(ste.getLineNumber());
        sb.append(" - ");
        sb.append("\u4e1a\u52a1\u6d41\u6c34\u53f7:").append(bizSerno).append("\u5f53\u524d\u8c03\u7528\u7684\u670d\u52a1\u4e3a:").append(service.getClass().getInterfaces()[0].getName()).append(".").append(method);
        logger.info(sb.toString());
    }

    public static final void debug(String bizSerno, Object service, String method) {
        StackTraceElement ste = new RuntimeException().getStackTrace()[1];
        StringBuffer sb = new StringBuffer();
        sb.append(ste.getClassName()).append(".").append(ste.getMethodName()).append(":").append(ste.getLineNumber());
        sb.append(" - ");
        sb.append("\u4e1a\u52a1\u6d41\u6c34\u53f7:").append(bizSerno).append("\u5f53\u524d\u8c03\u7528\u7684\u670d\u52a1\u4e3a:").append(service.getClass().getName()).append(".").append(method);
        logger.debug(sb.toString());
    }

    public static final void warn(String bizSerno, Object service, String method) {
        StackTraceElement ste = new RuntimeException().getStackTrace()[1];
        StringBuffer sb = new StringBuffer();
        sb.append(ste.getClassName()).append(".").append(ste.getMethodName()).append(":").append(ste.getLineNumber());
        sb.append(" - ");
        sb.append("\u4e1a\u52a1\u6d41\u6c34\u53f7:").append(bizSerno).append("\u5f53\u524d\u8c03\u7528\u7684\u670d\u52a1\u4e3a:").append(service.getClass().getName()).append(".").append(method);
        logger.warn(sb.toString());
    }

    public static final void error(String bizSerno, Object service, String method, Throwable e) {
        StackTraceElement ste = new RuntimeException().getStackTrace()[1];
        StringBuffer sb = new StringBuffer();
        sb.append(ste.getClassName()).append(".").append(ste.getMethodName()).append(":").append(ste.getLineNumber());
        sb.append(" - ");
        sb.append("\u4e1a\u52a1\u6d41\u6c34\u53f7:").append(bizSerno).append("\u8c03\u7528\u670d\u52a1:").append(service.getClass().getName()).append(".").append(method).append("\u51fa\u73b0\u5f02\u5e38!");
        sb.append("Cause by:").append(e.getMessage());
        logger.warn(sb.toString());
    }
}

