/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.core.util;

import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.regex.Pattern;

public final class NumberUtility {
    public static final boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final Integer toInteger(String str) {
        return NumberUtility.toInteger(str, null);
    }

    public static final Integer toInteger(String str, Integer defVal) {
        return NumberUtility.isInteger(str) ? Integer.valueOf(str) : defVal;
    }

    public static final Integer toInteger(Object object) {
        return NumberUtility.toInteger(object, null);
    }

    public static final Integer toInteger(Object object, Integer defVal) {
        String str = StringUtil.replaceObjNull(object);
        return NumberUtility.toInteger(str, defVal);
    }

    public static final boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final Double toDouble(String str) {
        return NumberUtility.toDouble(str, null);
    }

    public static final Double toDouble(String str, Double defVal) {
        return NumberUtility.isDouble(str) ? Double.valueOf(str) : defVal;
    }

    public static final Double toDouble(Object object) {
        return NumberUtility.toDouble(object, null);
    }

    public static final Double toDouble(Object object, Double defVal) {
        String str = StringUtil.replaceObjNull(object);
        return NumberUtility.toDouble(str, defVal);
    }

    public static final String formatAmt(String str) {
        return NumberUtility.formatAmt(str, "###,###.00");
    }

    public static final String formatAmt(String str, String pattern) {
        if (StringUtil.isNotEmpty(str)) {
            try {
                return new DecimalFormat(pattern).format(Double.valueOf(str));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final String formatAmt(Number number) {
        return NumberUtility.formatAmt(number.toString());
    }

    public static final String formatAmt(Number number, String pattern) {
        return NumberUtility.formatAmt(number.toString(), pattern);
    }

    public static final String digitalConvChinese(double amount) {
        DecimalFormat nf = new DecimalFormat("#0.##");
        nf.setMinimumFractionDigits(2);
        String amt = nf.format(amount);
        String dotPart = "";
        String intPart = "";
        int dotPos = amt.indexOf(46);
        if (dotPos != -1) {
            intPart = amt.substring(0, dotPos);
            dotPart = amt.substring(dotPos + 1);
        } else {
            intPart = amt;
        }
        if (intPart.length() > 16) {
            return null;
        }
        String intBig = NumberUtility.processInteger(intPart);
        String dotBig = NumberUtility.processDecimal(dotPart);
        if (dotBig.length() == 0 && intBig.length() != 0) {
            return intBig + "\u5143\u6574";
        }
        if (dotBig.length() == 0 && intBig.length() == 0) {
            return intBig + "\u96f6\u5143";
        }
        if (dotBig.length() != 0 && intBig.length() != 0) {
            return intBig + "\u5143" + dotBig;
        }
        return dotBig;
    }

    private static final String processDecimal(String dotPart) {
        String NUM = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        String DOTUNIT = "\u89d2\u5206\u5398";
        String strRet = "";
        for (int i = 0; i < dotPart.length() && i < 3; ++i) {
            int num = Integer.parseInt(dotPart.substring(i, i + 1));
            if (num == 0) continue;
            strRet = strRet + NUM.substring(num, num + 1) + DOTUNIT.substring(i, i + 1);
        }
        return strRet;
    }

    private static final String processInteger(String intPart) {
        String GRADEUNIT = "\u4edf\u4e07\u4ebf\u5146";
        int GRADE = 4;
        String result = "";
        String strTmp = "";
        int grade = intPart.length() / GRADE;
        if (intPart.length() % GRADE != 0) {
            ++grade;
        }
        for (int i = grade; i >= 1; --i) {
            strTmp = NumberUtility.getNowGradeVal(intPart, i);
            result = result + NumberUtility.conversionChinese(strTmp);
            result = NumberUtility.removeContinueZero(result);
            if (i <= 1) continue;
            result = NumberUtility.conversionChinese(strTmp).equals("\u96f6\u96f6\u96f6\u96f6") ? result + "\u96f6" : result + GRADEUNIT.substring(i - 1, i);
        }
        return result;
    }

    private static final String getNowGradeVal(String strVal, int grade) {
        int GRADE = 4;
        String rst = strVal.length() <= grade * GRADE ? strVal.substring(0, strVal.length() - (grade - 1) * GRADE) : strVal.substring(strVal.length() - grade * GRADE, strVal.length() - (grade - 1) * GRADE);
        return rst;
    }

    private static final String conversionChinese(String strVal) {
        String NUM = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        String UNIT = "\u4edf\u4f70\u62fe\u4e2a";
        String rst = "";
        for (int i = 0; i < strVal.length(); ++i) {
            String s = strVal.substring(i, i + 1);
            int num = Integer.parseInt(s);
            if (num == 0) {
                if (i == strVal.length()) continue;
                rst = rst + "\u96f6";
                continue;
            }
            rst = rst + NUM.substring(num, num + 1);
            if (i == strVal.length() - 1) continue;
            rst = rst + UNIT.substring(i + 4 - strVal.length(), i + 4 - strVal.length() + 1);
        }
        return rst;
    }

    private static final String removeContinueZero(String strVal) {
        String strBefore;
        String strRst = strBefore = strVal.substring(0, 1);
        for (int i = 1; i < strVal.length(); ++i) {
            String strNow = strVal.substring(i, i + 1);
            if (!strNow.equals("\u96f6") || !strBefore.equals("\u96f6")) {
                strRst = strRst + strNow;
            }
            strBefore = strNow;
        }
        if (strRst.substring(strRst.length() - 1, strRst.length()).equals("\u96f6")) {
            strRst = strRst.substring(0, strRst.length() - 1);
        }
        return strRst;
    }

    public static final boolean isOddNumber(int a) {
        return (a & 1) == 1;
    }

    public static final boolean isEvenNumber(int a) {
        return (a & 1) == 0;
    }

    public static final int getAverageValue(int x, int y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static final boolean is2NSquare(int x) {
        return (x & x - 1) == 0 && x != 0;
    }

    public static final boolean isBigDecimal(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final BigDecimal toBigDecimal(String str) {
        return NumberUtility.isBigDecimal(str) ? new BigDecimal(str) : null;
    }

    public static final BigDecimal toBigDecimal(String str, BigDecimal defVal) {
        return NumberUtility.isBigDecimal(str) ? new BigDecimal(str) : defVal;
    }

    public static final BigDecimal toBigDecimal(String str, String defVal) {
        return NumberUtility.toBigDecimal(str, new BigDecimal(defVal));
    }

    public static final BigDecimal toBigDecimal(String str, Number defVal) {
        return NumberUtility.toBigDecimal(str, defVal.toString());
    }

    public static final boolean isNumeric(String str) {
        return Pattern.compile("[0-9]*").matcher(str).matches();
    }

    public static final boolean isFloat(String str) {
        try {
            Float.parseFloat(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final Float toFloat(String str) {
        return NumberUtility.toFloat(str, null);
    }

    public static final Float toFloat(String str, Float defVal) {
        return NumberUtility.isFloat(str) ? Float.valueOf(str) : defVal;
    }

    public static final Float toFloat(Object object) {
        return NumberUtility.toFloat(object, null);
    }

    public static final Float toFloat(Object object, Float defVal) {
        String str = StringUtil.replaceObjNull(object);
        return NumberUtility.toFloat(str, defVal);
    }

    public static final <T extends Number> T fixNumber(T num, Class<T> cls) {
        if (Objects.nonNull(num)) {
            return num;
        }
        if (cls == Integer.class) {
            return (T)Integer.valueOf(0);
        }
        if (cls == Double.class) {
            return (T)Double.valueOf(0.0);
        }
        if (cls == Float.class) {
            return (T)Float.valueOf(0.0f);
        }
        if (cls == BigDecimal.class) {
            return (T)BigDecimal.ZERO;
        }
        return (T)BigDecimal.ZERO;
    }

    public static BigDecimal calcRemainder(BigDecimal num, BigDecimal op) {
        if (num == null || op == null || op.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal[] result = num.divideAndRemainder(op);
        return result[1];
    }

    public static Integer calcRemainder(Integer num, Integer op) {
        return num % op;
    }

    public static Long calcRemainder(Long num, Long op) {
        return num % op;
    }

    public static Double calcRemainder(Double num, Double op) {
        return num % op;
    }

    public static Float calcRemainder(Float num, Float op) {
        return Float.valueOf(num.floatValue() % op.floatValue());
    }

    public static BigDecimal sum(BigDecimal ... nums) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal num : nums) {
            result = result.add(num);
        }
        return result;
    }

    public static Integer sum(Integer ... nums) {
        Integer result = 0;
        for (Integer num : nums) {
            result = result + num;
        }
        return result;
    }

    public static Long sum(Long ... nums) {
        Long result = 0L;
        for (Long num : nums) {
            result = result + num;
        }
        return result;
    }

    public static Float sum(Float ... nums) {
        Float result = Float.valueOf(0.0f);
        for (Float num : nums) {
            result = Float.valueOf(result.floatValue() + num.floatValue());
        }
        return result;
    }

    public static Double sum(Double ... nums) {
        Double result = 0.0;
        for (Double num : nums) {
            result = result + num;
        }
        return result;
    }

    public static BigDecimal average(BigDecimal ... nums) {
        BigDecimal result = NumberUtility.sum(nums).divide(new BigDecimal(nums.length));
        return result;
    }

    public static Integer average(Integer ... nums) {
        Integer result = NumberUtility.sum(nums) / nums.length;
        return result;
    }

    public static Long average(Long ... nums) {
        Long result = NumberUtility.sum(nums) / (long)nums.length;
        return result;
    }

    public static Float average(Float ... nums) {
        Float result = Float.valueOf(NumberUtility.sum(nums).floatValue() / (float)nums.length);
        return result;
    }

    public static Double average(Double ... nums) {
        Double result = NumberUtility.sum(nums) / (double)nums.length;
        return result;
    }

    public static int random() {
        return (int)((Math.random() * 9.0 + 1.0) * 100000.0);
    }
}

